package cn.hperfect.nbquerier.core.components.convertor;

import cn.hperfect.nbquerier.core.metedata.field.ClassNbField;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hperfect.nbquerier.exceptions.TypeConvertException;

/**
 * 类型转换器
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/3 1:39 下午
 */
public interface ITypeConvertor {
    /**
     * 转换成参数
     *
     * @param value
     * @return
     */
    default Object convertToParam(DbType dbType, Object value) {

        return null;
    }

    /**
     * 转换成结果
     *
     * @return
     */
    default Object convertFromResult() {
        return null;
    }


    /**
     * 类型转换
     *
     * @param classNbField
     * @param value
     * @return
     * @throws TypeConvertException
     */
    Object convert(ClassNbField classNbField, Object value) throws TypeConvertException;

    default Object convert(Object value) throws TypeConvertException {
        return convert(null, value);
    }
}
