package cn.hperfect.nbquerier.core.components.builder.impl;

import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.toolkit.SqlUtils;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Table;

import java.util.HashMap;
import java.util.Map;

public class TableBuilder {
    Map<String, Table> tableMap = new HashMap<>();

    private final AliasBuilder aliasBuilder;

    public TableBuilder() {
        aliasBuilder = new AliasBuilder();
    }

    public TableBuilder(AliasBuilder aliasBuilder) {
        this.aliasBuilder = aliasBuilder;
    }

    public Table putTable(String schema, String tableId, String alias) {
        String key = SqlUtils.withAlias(schema, tableId);
        if (tableMap.containsKey(key)) {
            return tableMap.get(key);
        }
        Table table = new Table(schema, tableId);
        table.setAlias(new Alias(alias, false));
        tableMap.put(key, table);
        return table;
    }

    public Table putTable(String schema, String tableId) {
        return putTable(schema, tableId, aliasBuilder.putTable(tableId));
    }
    public Table putTable(Table table) {
        return putTable(table.getSchemaName(), table.getName());
    }
    public Table putTable(INbTable nbTable) {
        return putTable(nbTable.getSchema(), nbTable.getTableName());
    }
}
