package cn.hperfect.nbquerier.core.components.builder.impl;

import cn.hperfect.nbquerier.config.NbQuerierCons;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.toolkit.StringPool;
import cn.hutool.core.convert.Convert;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 参数器
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/12/2 7:17 下午
 */
@Getter
public class ParamBuilder {
    /**
     * 参数,有序集合,类型
     */
    private LinkedList<QueryValParam> params = new LinkedList<>();


    private AtomicInteger paramIndex = new AtomicInteger(0);

    public String formatVariable(NbQueryType type, Object value) {
        return formatVariable(type, value, false);
    }

    public String formatVariable(INbQueryType type, Object value, boolean update) {
        return formatVariable(type, value, update, true);
    }

    public String formatVariable(QueryValParam param) {
        return formatVariable(param.getType(), param.getValue(), false);
    }
    /**
     * @param type
     * @param value
     * @param update  是否是更新, 非更新会装换成???
     * @param toArray 数组类型是否转换成数组
     * @return
     */
    public String formatVariable(INbQueryType type, Object value, boolean update, boolean toArray) {
        List<String> patterns = new ArrayList<>();
        //数组值
        boolean arrayVal = type.isArray() && !update && toArray;
        if (arrayVal) {
            assert value instanceof Collection : "数组类型必须传数组";
            List<?> valueList = Convert.toList(value);
            for (Object o : valueList) {
                patterns.add(formatVariable(type.getArraySubType(), o, false));
            }
        } else {
            //todo where any 处理
            params.add(new QueryValParam(type, value));
            int index = paramIndex.getAndIncrement();
            patterns.add(String.format(NbQuerierCons.SQL_PARAM_FORMAT, index));
          /*  NbQueryType trueType = type.isArray() ? type.getArraySubType() : type;
            params.add(new QueryValParam(trueType, value));
            int index = paramIndex.getAndIncrement();
            patterns.add(String.format(NbQuerierCons.SQL_PARAM_FORMAT, index));*/
        }
        String res = String.join(StringPool.COMMA, patterns);
        //数组加上括号
        return arrayVal ? StringPool.LEFT_BRACKET + res + StringPool.RIGHT_BRACKET : res;
    }
}
