package cn.hperfect.nbquerier.core.components.builder.impl;

import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.StrPool;

import java.util.HashMap;
import java.util.Map;

/**
 * 所有表单put进来，生成不重复别名
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/10/27 6:29 下午
 */
public class AliasBuilder {

    private Map<String, String> tableAliasMap = new HashMap<>();

    public String putTable(String tableId) {
        if (!tableAliasMap.containsKey(tableId)) {
            for (int j = 0; j < tableId.length() - 1; j++) {
                for (int i = 0; i < tableId.length(); i++) {
                    String alias = tableId.substring(i, i + j + 1).toLowerCase();
                    if (!alias.equals(StrPool.UNDERLINE) && !tableAliasMap.containsValue(alias)) {
                        tableAliasMap.put(tableId, alias);
                        return alias;
                    }
                }
            }
            throw new NbSQLMessageException("设置别名错误");
        }
        return tableAliasMap.get(tableId);
    }

    public String getAliasName(String tableId) {
        Assert.isTrue(tableAliasMap.containsKey(tableId), "表单{}未设置别名", tableId);
        return tableAliasMap.get(tableId);
    }


}
