package cn.hperfect.nbquerier.core.components.builder;

import cn.hperfect.nbquerier.core.metedata.querier.UpdateData;
import cn.hperfect.nbquerier.core.querier.NbQuerier;

import java.util.List;
import java.util.Map;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 2:21 下午
 */
public interface INbSqlBuilder {
    default <T> String buildQuerySql(NbQuerier<T> querier) {
        return buildQuerySql(querier, null, true);
    }

    /**
     * 构建查询语句
     *
     * @param querier
     * @param field   查询指定字段
     * @param page
     * @return
     */
    <T> String buildQuerySql(NbQuerier<T> querier, String field, boolean page);

    String buildDeleteSql(NbQuerier<?> querier);

    /**
     * 构建保存语句(必须传下划线)
     *
     * @param querier
     * @param map
     * @return
     */
    String buildSaveSql(NbQuerier<?> querier, Map<String, Object> map);

    String buildSaveSql(NbQuerier<?> querier, List<Map<String, Object>> maps);

    String buildUpdateSql(NbQuerier<?> querier, UpdateData updateData);

    String buildFuncSql(NbQuerier<?> querier, String funcName, boolean last);

}
