package cn.hperfect.nbquerier.core.components.builder;

import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.core.metedata.table.ClassNbTable;
import cn.hperfect.nbquerier.core.querier.DefaultNbQuerier;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 9:51 上午
 */
public interface INbQueryBuilder {
    /**
     * 构建query对象
     *
     * @param <T>
     * @param clazz
     * @param alias
     * @return
     */
    <T> NbQuerier<T> build(Class<T> clazz, String alias);
    <T> NbQuerier<T> build(NbQuerier<?> querier, Class<T> clazz);

    default <T> NbQuerier<T> build(INbTable nbTable, String alias) {
        return build(nbTable, null, alias);
    }

    <T> NbQuerier<T> build(INbTable nbTable, Class<T> clazz, String alias);

    <T> DefaultNbQuerier<T> newNbQuerier();

    <T> NbQuerier<T> build(NbQueryInfo queryInfo);
    /**
     * 解析tableInfo
     *
     * @return
     */
    NbQueryInfo buildQueryInfo(Class<?> tableClazz, String alias);

    ClassNbTable parseTableInfo(Class<?> tableClazz);

    NbQueryInfo buildQueryInfo(INbTable nbTable, String alias);

    /**
     * 子查询
     *
     * @param querier
     * @param alias
     * @return
     */
    NbQueryInfo buildQueryInfo(NbQuerier<?> querier, String alias);
}
