package cn.hperfect.nbquerier.config.properties;

import cn.hperfect.nbquerier.enums.DbType;
import cn.hperfect.nbquerier.enums.IdType;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 1:03 下午
 */
@Data
@ConfigurationProperties(prefix = NbQuerierProperties.PREFIX)
public class NbQuerierProperties {
    public static final String PREFIX = "nb-querier";
    /**
     * 反射class是否使用缓存
     */
    private boolean classCache = true;
    /**
     * 表名是否装换成下划线
     */
    private boolean tableNameToUnderlineCase = true;
    private boolean fieldNameToUnderlineCase = true;
    /**
     * 输出日志
     */
    private boolean logSql = false;
    /**
     * todo 配置到DataSource,每个DataSource 的类型不同
     */
    private DbType dbType = DbType.POSTGRE_SQL;
    private IdType idType = IdType.NONE;

    private List<FillStrategyProperties> fillStrategies = new ArrayList<>();
    /**
     * 表单未开启软删除提示
     */
    private boolean softDeleteNotice = true;
    /**
     * 软删除字段
     */
    private String softDeleteField = "delete_time";
    /**
     * 雪花算法(hu tool)生成 workerId
     */
    private Long workerId = 1L;
    /**
     * 雪花算法生成 dataCenterId
     */
    private Long dataCenterId = 1L;
}
