package cn.hperfect.nbquerier.config;

import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.builder.INbQueryBuilder;
import cn.hperfect.nbquerier.core.components.builder.INbSqlBuilder;
import cn.hperfect.nbquerier.core.components.datasouce.INbDataSource;
import cn.hperfect.nbquerier.core.components.dialect.IDialectWare;
import cn.hperfect.nbquerier.core.components.executor.DefaultNbExecutor;
import cn.hperfect.nbquerier.core.components.executor.INbExecutor;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FieldFillStrategyRegistry;
import cn.hperfect.nbquerier.core.components.result.IResultSetHandler;
import cn.hperfect.nbquerier.core.components.result.json.HutoolJsonSerializer;
import cn.hperfect.nbquerier.core.components.result.json.NbJsonSerializer;
import cn.hperfect.nbquerier.core.components.route.ISchemaRoute;
import cn.hperfect.nbquerier.core.registry.NbInterceptorRegistry;
import cn.hperfect.nbquerier.core.registry.ValidatorRegistry;
import cn.hperfect.nbquerier.core.transaction.INbTransaction;
import cn.hperfect.nbquerier.core.transaction.ITransactionFactory;
import cn.hperfect.nbquerier.core.transaction.TransactionIsolationLevel;
import cn.hperfect.nbquerier.session.ISqlMapperBuilder;
import lombok.Getter;
import lombok.Setter;

import java.sql.Connection;

/**
 * 配置
 */
@Getter
@Setter
public class NbQuerierConfiguration {
    private final NbQuerierProperties config;
    /**
     * 校验器厂库
     */
    private ValidatorRegistry validatorRegistry;
    /**
     * 拦截器厂库
     */
    private NbInterceptorRegistry nbInterceptorRegistry;
    /**
     * 填充器厂库
     */
    private FieldFillStrategyRegistry fieldFillStrategyRegistry;
    /**
     * Query 构建器
     */
    private INbQueryBuilder nbQueryBuilder;
    /**
     * sql 构建器
     */
    private INbSqlBuilder nbSqlBuilder;

    /**
     * 结果集处理器
     */
    private IResultSetHandler resultSetHandler;

    private INbDataSource nbDataSource;

    private IDialectWare dialectWare;

    private ISchemaRoute schemaRoute;

    private ISqlMapperBuilder sqlMapperBuilder;
    private ITransactionFactory transactionFactory;
    private NbJsonSerializer jsonSerializer = new HutoolJsonSerializer();

    public NbQuerierConfiguration(NbQuerierProperties config) {
        this.config = config;
    }


    /**
     * 创建执行器
     *
     * @return
     */
    public INbExecutor newNbExecutor(Connection conn) {
        //创建事务

        return newNbExecutor(newTx(conn));
    }

    public INbExecutor newNbExecutor() {
        INbTransaction tx = newTx();
        return newNbExecutor(tx);
    }

    public INbTransaction newTx(Connection conn) {
        return this.transactionFactory.newTransaction(conn);
    }
    public INbTransaction newTx() {
        return this.transactionFactory.newTransaction(nbDataSource, TransactionIsolationLevel.NONE, false);
    }

    public INbExecutor newNbExecutor(INbTransaction tx) {
        return new DefaultNbExecutor(tx, config, nbSqlBuilder, resultSetHandler, jsonSerializer);
    }

}
