package cn.hperfect.nbquerier.config;

import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.builder.INbFieldBuilder;
import cn.hperfect.nbquerier.core.components.builder.INbSqlBuilder;
import cn.hperfect.nbquerier.core.components.builder.impl.DefaultFieldBuilder;
import cn.hperfect.nbquerier.core.components.builder.impl.DefaultNbQueryBuilder;
import cn.hperfect.nbquerier.core.components.builder.impl.DefaultSqlBuilder;
import cn.hperfect.nbquerier.core.components.datasouce.INbDataSource;
import cn.hperfect.nbquerier.core.components.dialect.DefaultDialectWare;
import cn.hperfect.nbquerier.core.components.dialect.IDialectWare;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FieldFillStrategyRegistry;
import cn.hperfect.nbquerier.core.components.interceptor.components.validator.impl.NotNullValidator;
import cn.hperfect.nbquerier.core.components.interceptor.components.validator.impl.UniqueValidator;
import cn.hperfect.nbquerier.core.components.interceptor.impl.ConstraintInterceptor;
import cn.hperfect.nbquerier.core.components.interceptor.impl.FillInterceptor;
import cn.hperfect.nbquerier.core.components.result.DefaultResultSetHandler;
import cn.hperfect.nbquerier.core.registry.NbInterceptorRegistry;
import cn.hperfect.nbquerier.core.registry.ValidatorRegistry;
import cn.hperfect.nbquerier.core.transaction.ITransactionFactory;
import cn.hutool.core.lang.Assert;
import lombok.Setter;

/**
 * 初始化
 */

public enum NbQuerierConfigFactory {
    INSTANCE,
    ;

    @Setter
    private NbQuerierConfiguration configuration;


    public NbQuerierConfiguration getConfiguration() {
        Assert.notNull(configuration, "未初始化配置,请先调用init方法");
        return configuration;
    }

    public NbQuerierConfiguration init(NbQuerierProperties config, ITransactionFactory transactionFactory, INbDataSource dataSource) {
        this.configuration = new NbQuerierConfiguration(config);
        configuration.setNbDataSource(dataSource);
        this.configuration.setTransactionFactory(transactionFactory);

        IDialectWare dialectWare = new DefaultDialectWare(config);
        configuration.setDialectWare(dialectWare);
        //配置
        configuration.setValidatorRegistry(newValidatorRegistry());
        configuration.setNbInterceptorRegistry(newInterceptorRegistry());
        configuration.setFieldFillStrategyRegistry(new FieldFillStrategyRegistry());

        configuration.setResultSetHandler(new DefaultResultSetHandler(config));
        configuration.setNbQueryBuilder(newNbQueryBuilder());
        configuration.setNbSqlBuilder(newNbSqlBuilder(dialectWare));

        return configuration;
    }

    private static NbInterceptorRegistry newInterceptorRegistry() {
        NbInterceptorRegistry nbInterceptorRegistry = new NbInterceptorRegistry();
        nbInterceptorRegistry.addInterceptor(new FillInterceptor());
        nbInterceptorRegistry.addInterceptor(new ConstraintInterceptor());
        return nbInterceptorRegistry;
    }

    private INbSqlBuilder newNbSqlBuilder(IDialectWare dialectWare) {
        INbFieldBuilder fieldBuilder = new DefaultFieldBuilder(dialectWare);
        return new DefaultSqlBuilder(dialectWare, fieldBuilder);
    }


    public DefaultNbQueryBuilder newNbQueryBuilder() {
        return new DefaultNbQueryBuilder(configuration);
    }



    public ValidatorRegistry newValidatorRegistry() {
        ValidatorRegistry validatorRegistry = new ValidatorRegistry();
        validatorRegistry.put(new NotNullValidator());
        validatorRegistry.put(UniqueValidator.INSTANCE);
        return validatorRegistry;
    }

}
