package cn.hperfect.nbquerier.config;

import cn.hperfect.nbquerier.core.components.executor.INbExecutor;

import java.sql.Connection;

public class NbExecutorFactory {

    private final NbQuerierConfiguration nbQuerierConfiguration;

    public NbExecutorFactory(NbQuerierConfiguration nbQuerierConfiguration) {
        this.nbQuerierConfiguration = nbQuerierConfiguration;
    }

    /**
     * 创建执行器
     *
     * @return
     */
    public INbExecutor newNbExecutor(Connection conn) {
        return nbQuerierConfiguration.newNbExecutor(conn);
    }

    public INbExecutor newNbExecutor() {
        return nbQuerierConfiguration.newNbExecutor();
    }
}
