package cn.hperfect.nbquerier.binding;

import cn.hperfect.nbquerier.parsing.TokenHandler;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;

import java.util.Map;

/**
 * ${} 处理器
 * 直接替换成字符串
 */
public class ParameterReplaceTokenHandler implements TokenHandler {

    private final Map<String, ArgVariable> argVariableMap;

    public ParameterReplaceTokenHandler(Map<String, ArgVariable> argVariableMap) {
        this.argVariableMap = argVariableMap;
    }

    @Override
    public String handleToken(String content) {
        ArgVariable argVariable = argVariableMap.get(content);
        Assert.notNull(argVariable, "未找到替换参数:{}", content);
        return Convert.toStr(argVariable.getValue());
    }

}
