package cn.hperfect.nbquerier.binding;

import cn.hperfect.nbquerier.core.components.builder.impl.ParamBuilder;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.parsing.TokenHandler;
import cn.hutool.core.lang.Assert;

import java.lang.reflect.Parameter;
import java.util.Map;

/**
 * 解析 #{} 参数
 * 调用查询器 的 变量构建器 格式化变量
 */
public class ParameterMappingTokenHandler implements TokenHandler {

    private final ParamBuilder paramBuilder;

    private final boolean isUpdate;

    private final Map<String, ArgVariable> argVariableMap;

    public ParameterMappingTokenHandler(ParamBuilder paramBuilder, boolean isUpdate, Map<String, ArgVariable> argVariableMap) {
        this.paramBuilder = paramBuilder;
        this.isUpdate = isUpdate;
        this.argVariableMap = argVariableMap;
    }

    @Override
    public String handleToken(String content) {
        ArgVariable argVariable = argVariableMap.get(content);
        Assert.notNull(argVariable, "未找到变量:#{{}}参数", content);
        INbQueryType type = getQueryType(argVariable.getParameter());
        return paramBuilder.formatVariable(type, argVariable.getValue(), isUpdate);
    }

    private INbQueryType getQueryType(Parameter parameter) {
        return NbQueryType.convertFromClass(parameter.getType(), null);

    }


}
