package cn.hperfect.nbquerier.annotation;

import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.metedata.UnknownClass;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;

import java.lang.annotation.*;

/**
 * 数据库表相关
 *
 * @author huanxi
 * @since 2016-01-23
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface NbField {

    /**
     * 数据库查询字段名
     */
    String value() default "";

    /**
     * 所属表名，连表字段
     */
    Class<?> table() default UnknownClass.class;

    /**
     * 字段别名
     *
     * @return
     */
    String alias() default "";

    /**
     * todo 改成 class
     *
     * @return
     */
    NbQueryType type() default NbQueryType.UNKNOWN;

    /**
     * todo 为空策略
     * 为空时设置为null
     *
     * @return
     */
    boolean updateNull() default false;

    /**
     * 是否为数据库表字段
     * 默认 true 存在，false 不存在
     */
    boolean exist() default true;

    String description() default "";

    /**
     * 为空时 插入default
     *
     * @return
     */
    boolean insertDefault() default false;

    /**
     * todo
     * 字段 where 实体查询比较条件
     * 默认 {@link QueryRuleEnum}
     */
    QueryRuleEnum condition() default QueryRuleEnum.EQ;
    //小数格式
    //format 时间格式
}
