package com.hperfect.test.datasource;

import cn.hperfect.nbquerier.annotation.TableId;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import lombok.Data;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * @author hperfect
 * @date 2022/12/2 11:18
 */
@SpringBootApplication
@Log4j2
public class TestApplication implements CommandLineRunner {
    @Resource
    DataSource dataSource;

    public static void main(String[] args) {
        SpringApplication.run(TestApplication.class, args);
    }

    @Data
    public static class Test{
        @TableId
        private Integer id;
        private String name;
    }
    @Override
    public void run(String... args) throws Exception {
        Test test = new Test();
        test.setId(2);
        test.setName("test");
        NbQuerier.table(Test.class).save(test);
        List<LinkedHashMap<String, Object>> list = NbQuerier.table(Test.class).selectMap();
        log.info("result:{}",list);
    }
}
