/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.springEx;

import cn.howardliu.gear.springEx.DuplicateServiceNameException;
import cn.howardliu.gear.springEx.ServiceRegister;
import cn.howardliu.gear.zk.discovery.ServiceDescription;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.ServletContextAware;

public class SpringMvcServiceScanner
implements ApplicationContextAware,
ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringMvcServiceScanner.class);
    private ApplicationContext ctx;
    private String contextPath = "";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.contextPath = servletContext.getContextPath();
    }

    public Collection<ServiceDescription> serviceList() throws Exception {
        HashMap<String, ServiceDescription> services = new HashMap<String, ServiceDescription>();
        String serviceRoot = "context-path";
        services.put(serviceRoot, new ServiceDescription(serviceRoot, this.contextPath));
        Map beansWithAnnotation = this.ctx.getBeansWithAnnotation(Controller.class);
        beansWithAnnotation.putAll(this.ctx.getBeansWithAnnotation(RestController.class));
        for (Object controller : beansWithAnnotation.values()) {
            RequestMapping[] methodRequestMappings;
            Class controllerClass = ClassUtils.getUserClass(controller);
            String className = controllerClass.getName();
            RequestMapping[] classRequestMappings = (RequestMapping[])controllerClass.getAnnotationsByType(RequestMapping.class);
            HashSet<String> uriPres = new HashSet<String>();
            if (classRequestMappings != null) {
                for (RequestMapping classRequestMapping : classRequestMappings) {
                    uriPres.addAll(Arrays.asList(classRequestMapping.value()));
                }
            }
            HashSet<String> serviceNamePres = new HashSet<String>();
            ServiceRegister[] classServiceRegisters = (ServiceRegister[])controllerClass.getAnnotationsByType(ServiceRegister.class);
            if (classServiceRegisters != null) {
                for (ServiceRegister classServiceRegister : classServiceRegisters) {
                    serviceNamePres.addAll(Arrays.asList(classServiceRegister.value()));
                }
            }
            Method[] allMethods = controllerClass.getMethods();
            ArrayList serviceRegisterMethods = Lists.newArrayList();
            for (Method method : allMethods) {
                ServiceRegister[] methodServiceRegisters = (ServiceRegister[])method.getAnnotationsByType(ServiceRegister.class);
                if (methodServiceRegisters == null || methodServiceRegisters.length <= 0 || (methodRequestMappings = (RequestMapping[])method.getAnnotationsByType(RequestMapping.class)) == null || methodRequestMappings.length <= 0) continue;
                serviceRegisterMethods.add(method);
            }
            for (Method method : serviceRegisterMethods) {
                RequestMapping[] methodRequestMappings2;
                String methodName = method.getName();
                HashSet<String> uriParts = new HashSet<String>();
                methodRequestMappings = methodRequestMappings2 = (RequestMapping[])method.getAnnotationsByType(RequestMapping.class);
                int n = methodRequestMappings.length;
                for (int i = 0; i < n; ++i) {
                    RequestMapping methodRequestMapping = methodRequestMappings[i];
                    uriParts.addAll(Arrays.asList(methodRequestMapping.value()));
                }
                HashSet<String> serviceUris = new HashSet<String>();
                for (String uriPart : uriParts) {
                    if (uriPres.isEmpty()) {
                        String uri = this.contextPath + "/" + uriPart;
                        serviceUris.add(uri.replaceAll("//+", "/").replaceAll("/$", "").replaceAll("^/", "") + ".json");
                        continue;
                    }
                    for (String uriPre : uriPres) {
                        String uri = this.contextPath + "/" + uriPre + "/" + uriPart;
                        serviceUris.add(uri.replaceAll("//+", "/").replaceAll("/$", "").replaceAll("^/", "") + ".json");
                    }
                }
                HashSet<String> servicePartNames = new HashSet<String>();
                ServiceRegister[] methodServiceRegisters = (ServiceRegister[])method.getAnnotationsByType(ServiceRegister.class);
                for (ServiceRegister serviceRegister : methodServiceRegisters) {
                    servicePartNames.addAll(Arrays.asList(serviceRegister.value()));
                }
                HashSet<String> serviceNames = new HashSet<String>();
                for (String servicePartName : servicePartNames) {
                    if (serviceNamePres.isEmpty()) {
                        serviceNames.add(servicePartName);
                        continue;
                    }
                    for (String serviceNamePre : serviceNamePres) {
                        String serviceName = serviceNamePre + "-" + servicePartName;
                        serviceNames.add(serviceName);
                    }
                }
                for (String serviceName : serviceNames) {
                    String string = className + "." + methodName;
                    if (services.containsKey(serviceName)) {
                        ServiceDescription duplicateServiceDescription = (ServiceDescription)services.get(serviceName);
                        throw new DuplicateServiceNameException(String.format("%s\u4e0e%s\u7684\u670d\u52a1\u540d%s\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", string, duplicateServiceDescription.getFullName(), serviceName));
                    }
                    for (String serviceUri : serviceUris) {
                        ServiceDescription description = new ServiceDescription(serviceName, serviceUri, string);
                        services.put(serviceName, description);
                    }
                }
            }
        }
        return services.values();
    }
}

