/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.springEx;

import cn.howardliu.gear.commons.server.TomcatInfoUtils;
import cn.howardliu.gear.springEx.ISpringMvcRegister;
import cn.howardliu.gear.springEx.SpringMvcRegister;
import cn.howardliu.gear.springEx.SpringMvcServiceScanner;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.scheduling.annotation.Scheduled;

public class SpringMvcRegisterWrapper
implements ISpringMvcRegister {
    private static final Logger logger = LoggerFactory.getLogger(SpringMvcRegisterWrapper.class);
    public static final String DEFAULT_IP_ENV_NAME = "LOCAL_IP_ADDRESS";
    private String ipEnvName = "LOCAL_IP_ADDRESS";
    private SpringMvcRegister springMvcRegister;
    private SpringMvcServiceScanner springMvcServiceScanner;
    private CuratorFramework client;
    private String basePath;
    private String preServiceName = "";

    @Override
    @PostConstruct
    public void regist() throws Exception {
        this.springMvcRegister = new SpringMvcRegister(this.client, this.basePath, this.getLocalIp(), this.getPort());
        this.springMvcRegister.setPreServiceName(this.preServiceName);
        this.springMvcRegister.setSpringMvcServiceScanner(this.springMvcServiceScanner);
        this.springMvcRegister.regist();
    }

    @Override
    @Scheduled(initialDelay=10000L, fixedDelay=30000L)
    public void refresh() throws Exception {
        this.springMvcRegister.refresh();
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        this.springMvcRegister.close();
    }

    public String getLocalIp() {
        String ipEnvName = (String)Validate.notNull((Object)this.getIpEnvName(), (String)"\u672c\u5730IP\u5730\u5740\u73af\u5883\u53d8\u91cf[\u9ed8\u8ba4\u4e3aLOCAL_IP_ADDRESS]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String localIp = System.getenv(ipEnvName);
        if (StringUtils.isBlank((CharSequence)localIp)) {
            localIp = System.getProperty(ipEnvName);
        }
        return (String)Validate.notNull((Object)localIp, (String)"\u672c\u5730IP\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    public Integer getPort() throws Exception {
        return TomcatInfoUtils.getPort();
    }

    public String getIpEnvName() {
        return this.ipEnvName;
    }

    public void setIpEnvName(String ipEnvName) {
        this.ipEnvName = ipEnvName;
    }

    @Required
    public void setSpringMvcServiceScanner(SpringMvcServiceScanner springMvcServiceScanner) {
        this.springMvcServiceScanner = springMvcServiceScanner;
    }

    @Required
    public void setClient(CuratorFramework client) {
        this.client = client;
    }

    @Required
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setPreServiceName(String preServiceName) {
        this.preServiceName = preServiceName;
    }
}

