/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.springEx;

import cn.howardliu.gear.springEx.ISpringMvcRegister;
import cn.howardliu.gear.springEx.SpringMvcServiceScanner;
import cn.howardliu.gear.zk.discovery.ServiceDescription;
import cn.howardliu.gear.zk.discovery.ServiceRegisterWrapper;
import java.io.IOException;
import java.util.Collection;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class SpringMvcRegister
implements ISpringMvcRegister {
    private static final Logger logger = LoggerFactory.getLogger(SpringMvcRegister.class);
    private static ServiceRegisterWrapper serviceRegisterWrapper;
    private SpringMvcServiceScanner springMvcServiceScanner;
    private String preServiceName = "";

    public SpringMvcRegister(CuratorFramework client, String basePath, String address, Integer port) throws Exception {
        serviceRegisterWrapper = new ServiceRegisterWrapper(client, basePath, address, port.intValue());
    }

    @Override
    public synchronized void regist() throws Exception {
        logger.info("\u6ce8\u518c\u5f00\u59cb\u3002\u3002\u3002");
        Collection<ServiceDescription> serviceList = this.springMvcServiceScanner.serviceList();
        for (ServiceDescription description : serviceList) {
            String trueServiceName = this.preServiceName + "-" + description.getServiceName();
            trueServiceName = trueServiceName.replaceAll("--+", "-").replaceAll("-$", "").replaceAll("^-", "");
            ServiceDescription trueService = new ServiceDescription(trueServiceName, description.getUri(), description.getFullName());
            serviceRegisterWrapper.regist(trueService);
        }
        logger.info("\u6ce8\u518c\u7ed3\u675f");
    }

    @Override
    public synchronized void refresh() throws Exception {
        logger.info("\u5237\u65b0\u5f00\u59cb\u3002\u3002\u3002");
        serviceRegisterWrapper.refresh("update at " + System.currentTimeMillis());
        logger.info("\u5237\u65b0\u7ed3\u675f");
    }

    @Override
    public void close() throws IOException {
        serviceRegisterWrapper.close();
    }

    @Required
    public void setSpringMvcServiceScanner(SpringMvcServiceScanner springMvcServiceScanner) {
        this.springMvcServiceScanner = springMvcServiceScanner;
    }

    public void setPreServiceName(String preServiceName) {
        if (preServiceName == null) {
            logger.warn("\u670d\u52a1\u540d\u524d\u7f00\u4e0d\u80fd\u4e3anull\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u7684\u7a7a\u5b57\u7b26\u4e32");
            this.preServiceName = "";
        } else {
            this.preServiceName = preServiceName.trim();
        }
    }
}

