/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.springEx;

import cn.howardliu.gear.zk.discovery.InstanceDetails;
import cn.howardliu.gear.zk.discovery.ServiceProviderWrapper;
import java.io.Closeable;
import java.io.IOException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringMvcProvider
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(SpringMvcProvider.class);
    private final ServiceProviderWrapper serviceProviderWrapper;
    private ProviderStrategy<InstanceDetails> providerStrategy;
    private String preServiceName = "";

    public SpringMvcProvider(CuratorFramework client, String basePath) throws Exception {
        this.serviceProviderWrapper = new ServiceProviderWrapper(client, basePath);
    }

    public SpringMvcProvider(CuratorFramework client, String basePath, ProviderStrategy<InstanceDetails> providerStrategy) throws Exception {
        this(client, basePath);
        this.serviceProviderWrapper.setProviderStrategy(providerStrategy);
    }

    public String provide(String serviceName) throws Exception {
        String trueServiceName = this.preServiceName + "-" + serviceName;
        trueServiceName = trueServiceName.replaceAll("--+", "-").replaceAll("-$", "").replaceAll("^-", "");
        return this.serviceProviderWrapper.provide(trueServiceName);
    }

    @Override
    public void close() throws IOException {
        this.serviceProviderWrapper.close();
    }

    public void setPreServiceName(String preServiceName) {
        if (preServiceName == null) {
            logger.warn("\u670d\u52a1\u540d\u524d\u7f00\u4e0d\u80fd\u4e3anull\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u7684\u7a7a\u5b57\u7b26\u4e32");
            this.preServiceName = "";
        } else {
            this.preServiceName = preServiceName.trim();
        }
    }
}

