/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.kafka;

import cn.howardliu.gear.kafka.KafkaProducerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerWrapper<K, V>
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaProducerWrapper.class);
    private KafkaProducer<K, V> kafkaProducer;

    public KafkaProducerWrapper(Properties config) {
        this.kafkaProducer = new KafkaProducerFactory(config).build();
    }

    public KafkaProducerWrapper(String bootstrapServers) {
        this.kafkaProducer = new KafkaProducerFactory(bootstrapServers).build();
    }

    public boolean send(String topic, K key, V msg) {
        return this.send(topic, key, msg, new Callback<K, V>(){

            @Override
            public void execute(K key, V value, RecordMetadata metadata, Exception exception) {
                if (exception == null) {
                    logger.debug("producer\u53d1\u9001\u6d88\u606f\u6210\u529f\uff0ctopic={}, partition={}, offset={}", new Object[]{metadata.topic(), metadata.partition(), metadata.offset()});
                } else {
                    logger.error("producer\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)exception);
                }
            }
        });
    }

    public boolean send(String topic, final K key, final V value, final Callback<K, V> callback) {
        try {
            ProducerRecord record = key == null ? new ProducerRecord(topic, value) : new ProducerRecord(topic, key, value);
            this.kafkaProducer.send(record, new org.apache.kafka.clients.producer.Callback(){

                public void onCompletion(RecordMetadata metadata, Exception exception) {
                    callback.execute(key, value, metadata, exception);
                }
            });
            return true;
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25, topic={}, key={}, value={}", new Object[]{topic, key, value, e});
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        this.kafkaProducer.close();
    }

    public static interface Callback<K, V> {
        public void execute(K var1, V var2, RecordMetadata var3, Exception var4);
    }
}

