/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.commons.utils;

import cn.howardliu.gear.commons.utils.Type$;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class SystemInfo$ {
    public static final SystemInfo$ MODULE$;
    private final double ONE_KB;
    private final double ONE_MB;
    private final double ONE_GB;

    static {
        new SystemInfo$();
    }

    public double ONE_KB() {
        return this.ONE_KB;
    }

    public double ONE_MB() {
        return this.ONE_MB;
    }

    public double ONE_GB() {
        return this.ONE_GB;
    }

    public java.util.Map<String, Object> getSystemInfo() {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        HashMap info = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)os.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)os.getVersion()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"arch"), (Object)os.getArch()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"systemLoadAverage"), (Object)BoxesRunTime.boxToDouble((double)os.getSystemLoadAverage()))}));
        info = info.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"committedVirtualMemorySize"), this.addGetterIfAvaliable(os, "committedVirtualMemorySize")));
        info = info.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"freePhysicalMemorySize"), this.addGetterIfAvaliable(os, "freePhysicalMemorySize")));
        info = info.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"freeSwapSpaceSize"), this.addGetterIfAvaliable(os, "freeSwapSpaceSize")));
        info = info.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"processCpuTime"), this.addGetterIfAvaliable(os, "processCpuTime")));
        info = info.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"totalPhysicalMemorySize"), this.addGetterIfAvaliable(os, "totalPhysicalMemorySize")));
        info = info.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"totalSwapSpaceSize"), this.addGetterIfAvaliable(os, "totalSwapSpaceSize")));
        info = info.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"openFileDescriptorCount"), this.addGetterIfAvaliable(os, "openFileDescriptorCount")));
        info = info.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxFileDescriptorCount"), this.addGetterIfAvaliable(os, "maxFileDescriptorCount")));
        try {
            if (!os.getName().toLowerCase(Locale.ROOT).startsWith("windows")) {
                info = info.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"uname"), (Object)this.execute("uname -a")));
                info = info.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"uptime"), (Object)this.execute("uptime")));
            }
        }
        catch (Exception exception) {}
        return Type$.MODULE$.$greater$greater((Map<String, Object>)info);
    }

    public java.util.Map<String, Object> getJvmInfo() {
        String javaVersion = System.getProperty("java.specification.version", "unknown");
        String javaVendor = System.getProperty("java.specification.vendor", "unknown");
        String javaName = System.getProperty("java.specification.name", "unknown");
        String jreVersion = System.getProperty("java.version", "unknown");
        String jreVendor = System.getProperty("java.vendor", "unknown");
        String vmVersion = System.getProperty("java.vm.version", "unknown");
        String vmVendor = System.getProperty("java.vm.vendor", "unknown");
        String vmName = System.getProperty("java.vm.name", "unknown");
        HashMap jvm = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)new StringBuilder().append((Object)jreVersion).append((Object)" ").append((Object)vmVersion).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new StringBuilder().append((Object)jreVendor).append((Object)" ").append((Object)vmName).toString())}));
        jvm = jvm.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"spec"), (Object)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"vendor"), (Object)javaVendor), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)javaName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)javaVersion)}))));
        jvm = jvm.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"jre"), (Object)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"vendor"), (Object)jreVendor), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)jreVersion)}))));
        jvm = jvm.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"vm"), (Object)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"vendor"), (Object)vmVendor), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)vmName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)vmVersion)}))));
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        double percentUsed = (double)used / (double)max * (double)100;
        jvm = jvm.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"processors"), (Object)BoxesRunTime.boxToInteger((int)runtime.availableProcessors())));
        DecimalFormat df = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ROOT));
        HashMap mem = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"free"), (Object)this.humanReadableUnits(free, df)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"used"), (Object)new StringBuilder().append((Object)this.humanReadableUnits(used, df)).append((Object)" (%").append((Object)df.format(percentUsed)).append((Object)")").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"total"), (Object)this.humanReadableUnits(total, df)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"max"), (Object)this.humanReadableUnits(max, df))}));
        mem = mem.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"raw"), (Object)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"free"), (Object)BoxesRunTime.boxToLong((long)free)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"used"), (Object)BoxesRunTime.boxToLong((long)used)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"used%"), (Object)BoxesRunTime.boxToDouble((double)percentUsed)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"total"), (Object)BoxesRunTime.boxToLong((long)total)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"max"), (Object)BoxesRunTime.boxToLong((long)max))}))));
        jvm = jvm.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"memory"), (Object)mem));
        RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
        jvm = jvm.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"jmx"), (Object)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"bootclasspath"), (Object)mx.getBootClassPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"classpath"), (Object)mx.getClassPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"commandLineArgs"), mx.getInputArguments()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"startTime"), (Object)BoxesRunTime.boxToLong((long)mx.getStartTime())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"upTimeMS"), (Object)BoxesRunTime.boxToLong((long)mx.getUptime()))}))));
        return Type$.MODULE$.$greater$greater((Map<String, Object>)jvm);
    }

    private String humanReadableUnits(long bytes, DecimalFormat df) {
        return (long)((double)bytes / this.ONE_GB()) > 0L ? new StringBuilder().append((Object)df.format((double)bytes / this.ONE_GB())).append((Object)"GB").toString() : ((long)((double)bytes / this.ONE_MB()) > 0L ? new StringBuilder().append((Object)df.format((double)bytes / this.ONE_MB())).append((Object)"MB").toString() : ((long)((double)bytes / this.ONE_KB()) > 0L ? new StringBuilder().append((Object)df.format((double)bytes / this.ONE_KB())).append((Object)"KB").toString() : new StringBuilder().append((Object)df.format(bytes)).append((Object)"bytes").toString()));
    }

    private Object addGetterIfAvaliable(Object obj, String getter) {
        Object object;
        try {
            String n = new StringBuilder().append(Character.toUpperCase(getter.charAt(0))).append((Object)getter.substring(1)).toString();
            Method m = obj.getClass().getMethod(new StringBuilder().append((Object)"get").append((Object)n).toString(), new Class[0]);
            m.setAccessible(true);
            Object[] objectArray = new Object[1];
            objectArray[0] = null;
            object = m.invoke(obj, objectArray);
        }
        catch (Exception exception) {
            object = "";
        }
        return object;
    }

    private String execute(String cmd) {
        String string;
        InputStream in = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
            in = process.getInputStream();
            string = IOUtils.toString((Reader)new InputStreamReader(in, Charset.defaultCharset()));
        }
        catch (Error error) {
            if (error.getMessage() != null && (error.getMessage().contains("posix_spawn") || error.getMessage().contains("UNIXProcess"))) {
                return new StringBuilder().append((Object)"(error executing: ").append((Object)cmd).append((Object)")").toString();
            }
            throw error;
        }
        catch (Exception exception) {
            string = new StringBuilder().append((Object)"(error executing: ").append((Object)cmd).append((Object)")").toString();
        }
        finally {
            if (process != null) {
                IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                IOUtils.closeQuietly((InputStream)process.getInputStream());
                IOUtils.closeQuietly((InputStream)process.getErrorStream());
            }
        }
        return string;
    }

    private SystemInfo$() {
        MODULE$ = this;
        this.ONE_KB = 1024;
        this.ONE_MB = this.ONE_KB() * this.ONE_KB();
        this.ONE_GB = this.ONE_KB() * this.ONE_MB();
    }
}

