/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.commons.utils;

import cn.howardliu.gear.commons.annotation.Key;
import cn.howardliu.gear.commons.utils.StringUtilsEx;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesUtils.class);

    public static <T> T parseObject(Properties properties, Class<T> clazz) {
        try {
            Field[] fields;
            Constructor<T> defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            T o = defaultConstructor.newInstance(new Object[0]);
            for (Field field : fields = clazz.getDeclaredFields()) {
                String key;
                String fieldName = field.getName();
                Class<?> fieldType = field.getType();
                Key fieldKey = field.getAnnotation(Key.class);
                if (fieldKey == null || PropertiesUtils.isBlank(key = fieldKey.value())) continue;
                String value = properties.getProperty(key);
                if (fieldType == String.class) {
                    PropertiesUtils.setStringValue(o, clazz, fieldName, value);
                    continue;
                }
                if (fieldType == Byte.class || fieldType == Byte.TYPE) {
                    PropertiesUtils.setByteValue(o, clazz, fieldName, value);
                    continue;
                }
                if (fieldType == Short.class || fieldType == Short.TYPE) {
                    PropertiesUtils.setShortValue(o, clazz, fieldName, value);
                    continue;
                }
                if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                    PropertiesUtils.setIntValue(o, clazz, fieldName, value);
                    continue;
                }
                if (fieldType == Character.class || fieldType == Character.TYPE) {
                    PropertiesUtils.setCharValue(o, clazz, fieldName, value);
                    continue;
                }
                if (fieldType == Long.class || fieldType == Long.TYPE) {
                    PropertiesUtils.setLongValue(o, clazz, fieldName, value);
                    continue;
                }
                if (fieldType == Float.class || fieldType == Float.TYPE) {
                    PropertiesUtils.setFloatValue(o, clazz, fieldName, value);
                    continue;
                }
                if (fieldType == Double.class || fieldType == Double.TYPE) {
                    PropertiesUtils.setDoubleValue(o, clazz, fieldName, value);
                    continue;
                }
                if (fieldType != Boolean.class && fieldType != Boolean.TYPE) continue;
                PropertiesUtils.setBooleanValue(o, clazz, fieldName, value);
            }
            return o;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6570\u636e\u51fa\u9519, properties={}, class={}", new Object[]{properties, clazz, e});
            return null;
        }
    }

    private static <T> void setBooleanValue(Object o, Class<T> clazz, String fieldName, String value) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Boolean _value;
        if (PropertiesUtils.isBlank(value)) {
            _value = false;
            logger.warn("{}\u5bf9\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503cfalse", (Object)fieldName);
        } else {
            _value = Boolean.valueOf(value);
        }
        PropertiesUtils.setValue(o, clazz, fieldName, _value);
    }

    private static <T> void setDoubleValue(Object o, Class<T> clazz, String fieldName, String value) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Double _value;
        if (PropertiesUtils.isBlank(value)) {
            _value = 0.0;
            logger.warn("{}\u5bf9\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c0", (Object)fieldName);
        } else if (StringUtilsEx.isDoubleNumber(value)) {
            _value = Double.valueOf(value);
        } else {
            throw new IllegalArgumentException("\u5b57\u6bb5" + fieldName + "\u5bf9\u5e94\u6570\u636e\u4e0d\u662f\u6570\u5b57");
        }
        PropertiesUtils.setValue(o, clazz, fieldName, _value);
    }

    private static <T> void setFloatValue(Object o, Class<T> clazz, String fieldName, String value) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Float _value;
        if (PropertiesUtils.isBlank(value)) {
            _value = Float.valueOf(0.0f);
            logger.warn("{}\u5bf9\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c0", (Object)fieldName);
        } else if (StringUtilsEx.isDoubleNumber(value)) {
            _value = Float.valueOf(value);
        } else {
            throw new IllegalArgumentException("\u5b57\u6bb5" + fieldName + "\u5bf9\u5e94\u6570\u636e\u4e0d\u662f\u6570\u5b57");
        }
        PropertiesUtils.setValue(o, clazz, fieldName, _value);
    }

    private static <T> void setLongValue(Object o, Class<T> clazz, String fieldName, String value) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Long _value;
        if (PropertiesUtils.isBlank(value)) {
            _value = 0L;
            logger.warn("{}\u5bf9\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c0", (Object)fieldName);
        } else if (StringUtilsEx.isDigits(value)) {
            _value = Long.valueOf(value);
        } else {
            throw new IllegalArgumentException("\u5b57\u6bb5" + fieldName + "\u5bf9\u5e94\u6570\u636e\u4e0d\u662f\u6570\u5b57");
        }
        PropertiesUtils.setValue(o, clazz, fieldName, _value);
    }

    private static <T> void setCharValue(Object o, Class<T> clazz, String fieldName, String value) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Character _value;
        if (value == null || value.isEmpty()) {
            _value = Character.valueOf('\u0000');
            logger.warn("{}\u5bf9\u5e94\u6570\u636e\u4e3anull\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c'\\0'", (Object)fieldName);
        } else {
            _value = Character.valueOf(value.trim().charAt(0));
        }
        PropertiesUtils.setValue(o, clazz, fieldName, _value);
    }

    private static <T> void setShortValue(Object o, Class<T> clazz, String fieldName, String value) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Short _value;
        if (PropertiesUtils.isBlank(value)) {
            _value = 0;
            logger.warn("{}\u5bf9\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c0", (Object)fieldName);
        } else if (StringUtilsEx.isDigits(value)) {
            _value = Short.valueOf(value);
        } else {
            throw new IllegalArgumentException("\u5b57\u6bb5" + fieldName + "\u5bf9\u5e94\u6570\u636e\u4e0d\u662f\u6570\u5b57");
        }
        PropertiesUtils.setValue(o, clazz, fieldName, _value);
    }

    private static <T> void setByteValue(Object o, Class<T> clazz, String fieldName, String value) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Byte _value;
        if (PropertiesUtils.isBlank(value)) {
            _value = 0;
            logger.warn("{}\u5bf9\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c0", (Object)fieldName);
        } else if (StringUtilsEx.isDigits(value)) {
            _value = Byte.valueOf(value);
        } else {
            throw new IllegalArgumentException("\u5b57\u6bb5" + fieldName + "\u5bf9\u5e94\u6570\u636e\u4e0d\u662f\u6570\u5b57");
        }
        PropertiesUtils.setValue(o, clazz, fieldName, _value);
    }

    private static void setIntValue(Object o, Class<?> clazz, String fieldName, String value) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Integer _value;
        if (PropertiesUtils.isBlank(value)) {
            _value = 0;
            logger.warn("{}\u5bf9\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c0", (Object)fieldName);
        } else if (StringUtilsEx.isDigits(value)) {
            _value = Integer.valueOf(value);
        } else {
            throw new IllegalArgumentException("\u5b57\u6bb5" + fieldName + "\u5bf9\u5e94\u6570\u636e\u4e0d\u662f\u6570\u5b57");
        }
        PropertiesUtils.setValue(o, clazz, fieldName, _value);
    }

    private static void setStringValue(Object o, Class<?> clazz, String fieldName, String value) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        PropertiesUtils.setValue(o, clazz, fieldName, value);
    }

    private static void setValue(Object o, Class<?> clazz, String fieldName, Object value) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor propDesc = new PropertyDescriptor(fieldName, clazz);
        Method setMethod = propDesc.getWriteMethod();
        setMethod.invoke(o, value);
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }
}

