/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.commons.server;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatInfoUtils {
    private static final Logger logger = LoggerFactory.getLogger(TomcatInfoUtils.class);

    public static Integer getPort() throws Exception {
        MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
        Set<ObjectName> names = server.queryNames(new ObjectName("Catalina:type=Connector,*"), null);
        for (ObjectName name : names) {
            String protocol = server.getAttribute(name, "protocol").toString();
            String scheme = server.getAttribute(name, "scheme").toString();
            logger.debug("protocol={}, scheme={}", (Object)protocol, (Object)scheme);
            if (!protocol.toLowerCase().contains("http") || !scheme.toLowerCase().contains("http")) continue;
            return (Integer)server.getAttribute(name, "port");
        }
        return 0;
    }

    private void getInfo() throws Exception {
        ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer mBeanServer : mBeanServers) {
            Set<ObjectName> objectNames = mBeanServer.queryNames(null, null);
            for (ObjectName objectName : objectNames) {
                MBeanAttributeInfo[] attributes;
                MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
                logger.debug("objectName={}, description={}", (Object)objectName, (Object)mBeanInfo.getDescription());
                for (MBeanAttributeInfo attribute : attributes = mBeanInfo.getAttributes()) {
                    String name = attribute.getName();
                    String description = attribute.getDescription();
                    String type = attribute.getType();
                    logger.debug("name={}, description={}, type={}", new Object[]{name, description, type});
                    try {
                        Object attr = mBeanServer.getAttribute(objectName, name);
                        logger.debug("canonicalName={}, type={}, value={}", new Object[]{objectName.getCanonicalName(), attr == null ? "null" : attr.getClass().getCanonicalName(), attr});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

