/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.commons.httpclient.simple;

import cn.howardliu.gear.commons.httpclient.simple.HttpRequester;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolingHttpRequester
extends HttpRequester {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Object lock = new Object();
    private static PoolingHttpRequester poolingHttpRequester;
    private static final PoolingHttpClientConnectionManager cm;
    private static CloseableHttpClient client;

    private PoolingHttpRequester() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PoolingHttpRequester getHttpRequester() {
        if (poolingHttpRequester == null) {
            Object object = lock;
            synchronized (object) {
                if (poolingHttpRequester == null) {
                    poolingHttpRequester = new PoolingHttpRequester();
                }
            }
        }
        return poolingHttpRequester;
    }

    @Override
    CloseableHttpClient getHttpClient() {
        return client;
    }

    public PoolingHttpRequester setConnPoolMaxTotal(int max) {
        cm.setMaxTotal(max);
        return this;
    }

    public PoolingHttpRequester setConnPoolMaxPerRoute(int max) {
        cm.setDefaultMaxPerRoute(max);
        return this;
    }

    public PoolingHttpRequester setConnPooMaxPerRoute(HttpRoute route, int max) {
        cm.setMaxPerRoute(route, max);
        return this;
    }

    @Override
    public String get(String url, List<NameValuePair> params) throws URISyntaxException, IOException {
        URI uri = new URIBuilder(url).build();
        HttpHost httpHost = URIUtils.extractHost((URI)uri);
        if (httpHost == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6709\u6548\u7684HOST");
        }
        CloseableHttpClient client = this.getHttpClient();
        HttpGet httpGet = new HttpGet(uri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executing request: ", (Object)httpGet.getRequestLine());
        }
        if (params != null && params.size() > 0) {
            httpGet.setURI(new URI(httpGet.getURI().toString() + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8))));
        }
        String respText = this.execute(client, httpHost, (HttpRequest)httpGet);
        return respText;
    }

    static {
        cm = new PoolingHttpClientConnectionManager();
        client = null;
        cm.setMaxTotal(256);
        cm.setDefaultMaxPerRoute(16);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

