/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.commons.httpclient.simple;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpRequester {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_CONTENT_TYPE = ContentType.APPLICATION_JSON.getMimeType();

    abstract CloseableHttpClient getHttpClient();

    CloseableHttpClient getHttpClient(HttpHost httpHost, String username, String password) {
        return this.getHttpClient();
    }

    public String get(String url) throws URISyntaxException, IOException {
        return this.get(url, new ArrayList<NameValuePair>());
    }

    public String get(String url, Map<String, String> params) throws URISyntaxException, IOException {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(params.size());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return this.get(url, nameValuePairs);
    }

    public String get(String url, NameValuePair param) throws URISyntaxException, IOException {
        return this.get(url, Arrays.asList(param));
    }

    public String get(String url, List<NameValuePair> params) throws URISyntaxException, IOException {
        String respText;
        URI uri = new URIBuilder(url).build();
        HttpHost httpHost = URIUtils.extractHost((URI)uri);
        if (httpHost == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6709\u6548\u7684HOST");
        }
        try (CloseableHttpClient client = this.getHttpClient();){
            respText = this.get(client, httpHost, uri, params);
        }
        return respText;
    }

    public String get(String url, List<NameValuePair> params, String username, String password) throws URISyntaxException, IOException {
        String respText;
        URI uri = new URIBuilder(url).build();
        HttpHost httpHost = URIUtils.extractHost((URI)uri);
        if (httpHost == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6709\u6548\u7684HOST");
        }
        try (CloseableHttpClient client = this.getHttpClient(httpHost, username, password);){
            respText = this.get(client, httpHost, uri, params);
        }
        return respText;
    }

    private String get(CloseableHttpClient client, HttpHost httpHost, URI uri, List<NameValuePair> params) throws URISyntaxException, IOException {
        HttpGet httpGet = new HttpGet(uri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executing request: ", (Object)httpGet.getRequestLine());
        }
        if (params != null && params.size() > 0) {
            httpGet.setURI(new URI(httpGet.getURI().toString() + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8))));
        }
        return this.execute(client, httpHost, (HttpRequest)httpGet);
    }

    public String post(String url) throws URISyntaxException, IOException {
        return this.get(url);
    }

    public String post(String url, String postMessage) throws URISyntaxException, IOException {
        StringEntity httpEntity = null;
        if (StringUtils.isNotEmpty((CharSequence)postMessage)) {
            httpEntity = new StringEntity(postMessage, Consts.UTF_8);
        }
        return this.post(url, (HttpEntity)httpEntity);
    }

    public String post(String url, String postMessage, int timeout) throws URISyntaxException, IOException {
        StringEntity httpEntity = null;
        if (StringUtils.isNotEmpty((CharSequence)postMessage)) {
            httpEntity = new StringEntity(postMessage, Consts.UTF_8);
        }
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
        return this.post(url, (HttpEntity)httpEntity, config);
    }

    public String post(String url, String postMessage, String contentType) throws URISyntaxException, IOException {
        StringEntity httpEntity = null;
        if (StringUtils.isNotEmpty((CharSequence)postMessage)) {
            httpEntity = new StringEntity(postMessage, Consts.UTF_8);
        }
        return this.post(url, (HttpEntity)httpEntity, contentType);
    }

    public String post(String url, HttpEntity httpEntity) throws URISyntaxException, IOException {
        return this.post(url, httpEntity, ContentType.APPLICATION_JSON.getMimeType());
    }

    public String post(String url, HttpEntity httpEntity, RequestConfig config) throws URISyntaxException, IOException {
        return this.post(url, httpEntity, ContentType.APPLICATION_JSON.getMimeType(), config);
    }

    public String post(String url, HttpEntity httpEntity, String contentType) throws URISyntaxException, IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
        return this.post(url, httpEntity, contentType, config);
    }

    public String post(String url, HttpEntity httpEntity, String contentType, RequestConfig config) throws URISyntaxException, IOException {
        String respText;
        URI uri = new URIBuilder(url).build();
        HttpHost httpHost = URIUtils.extractHost((URI)uri);
        if (httpHost == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6709\u6548\u7684HOST");
        }
        try (CloseableHttpClient client = this.getHttpClient();){
            Header[] headers;
            HttpPost httpPost = new HttpPost(uri);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executing request: ", (Object)httpPost.getRequestLine());
            }
            if (httpEntity != null) {
                httpPost.setEntity(httpEntity);
            }
            if (contentType != null) {
                httpPost.setHeader("Content-Type", contentType);
            } else {
                httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            }
            if (config != null) {
                httpPost.setConfig(config);
            }
            for (Header h : headers = httpPost.getAllHeaders()) {
                this.logger.debug("{}={}", (Object)h.getName(), (Object)h.getValue());
            }
            respText = this.execute(client, httpHost, (HttpRequest)httpPost);
        }
        return respText;
    }

    public String form(String url, Map<String, String> params) throws URISyntaxException, IOException {
        return this.form(url, params, DEFAULT_CONTENT_TYPE);
    }

    public String form(String url, Map<String, String> params, String contentType) throws URISyntaxException, IOException {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(params.size());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return this.form(url, nameValuePairs, contentType);
    }

    public String form(String url, List<NameValuePair> params) throws URISyntaxException, IOException {
        return this.form(url, params, DEFAULT_CONTENT_TYPE);
    }

    public String form(String url, List<NameValuePair> params, String contentType) throws URISyntaxException, IOException {
        Object httpEntity = params == null ? new StringEntity("", Consts.UTF_8) : new UrlEncodedFormEntity(params, Consts.UTF_8);
        return this.post(url, (HttpEntity)httpEntity, contentType);
    }

    protected String execute(CloseableHttpClient client, HttpHost httpHost, HttpRequest httpRequest) throws IOException, URISyntaxException {
        String respText = null;
        try (CloseableHttpResponse response = client.execute(httpHost, httpRequest);){
            Header[] headers = response.getAllHeaders();
            if (this.logger.isDebugEnabled()) {
                for (Header header : headers) {
                    this.logger.debug("the headers of this message \uff1a{} = {}", (Object)header.getName(), (Object)header.getValue());
                }
            }
            StatusLine statusLine = response.getStatusLine();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("the status line of this response is {}", (Object)statusLine.getStatusCode());
            }
            if (statusLine.getStatusCode() == 200) {
                respText = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
                this.logger.debug("the message entity of this response:\n\r{}", (Object)respText);
            } else if (statusLine.getStatusCode() == 301 || statusLine.getStatusCode() == 302) {
                String string = this.get(response.getLastHeader("Location").getValue());
                return string;
            }
        }
        return respText;
    }
}

