/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.commons.cache;

import cn.howardliu.gear.commons.cache.Cache;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsingMemoryCache<T>
implements Cache<T> {
    private static final Logger logger = LoggerFactory.getLogger(UsingMemoryCache.class);
    private final Map<String, T> values = new ConcurrentHashMap<String, T>();

    @Override
    public Collection<String> keys() {
        return this.values.keySet();
    }

    @Override
    public T get(String k) {
        return this.values.get(k);
    }

    @Override
    public void put(String k, T v) {
        this.values.put(k, v);
    }

    @Override
    public T remove(String k) {
        if (this.values.containsKey(k)) {
            return this.values.remove(k);
        }
        return null;
    }
}

