package cn.hiroz.android.core.task;

import cn.hiroz.android.core.BaseTask;
import cn.hiroz.android.core.exception.CoreException;

/**
 * Created by hiro on 1/31/15.
 */
public abstract class BaseCallbackTask extends BaseTask {

    protected transient CoredroidCallback callback = null;

    public CoredroidCallback getCallback() {
        return callback;
    }

    public void setCallback(CoredroidCallback callback) {
        this.callback = callback;
    }

    protected void publishSuccess(int arg1, int arg2, Object... args) {
        if (this.callback != null) {
            this.callback.onSuccess(tag, arg1, arg2, args);
        }
    }

    protected void publishFailed(CoreException exception) {
        if (engine != null && continueTry()) {
            engine.enqueue(this);
        } else {
            if (this.callback != null) {
                this.callback.onFailed(tag, exception);
            }
        }
    }

    protected void publishProgress(int arg1, int arg2, Object... args) {
        if (this.callback != null) {
            this.callback.onProgress(tag, arg1, arg2, args);
        }
    }

}
