package cn.hiroz.android.core;

import android.util.Log;
import cn.hiroz.android.core.task.RetryPolicy;
import cn.hiroz.android.core.utils.Stoppable;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by hiro on 1/31/15.
 */
public abstract class BaseTask implements Runnable, Comparable<BaseTask>, Serializable, Stoppable, RetryPolicy {

    protected String tag;
    protected CoredroidEngine engine = null;
    protected int priority;
    protected ReentrantLock lock;
    protected boolean stopping = false;

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public CoredroidEngine getEngine() {
        return engine;
    }

    public void setEngine(CoredroidEngine engine) {
        this.engine = engine;
    }

    public ReentrantLock getLock() {
        return lock;
    }

    public void setLock(ReentrantLock lock) {
        this.lock = lock;
    }

    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public boolean continueTry() {
        return false;
    }

    @Override
    public int compareTo(BaseTask another) {
        return this.priority - another.priority;
    }

    @Override
    public void stop() {
        stopping = true;
    }

    @Override
    public boolean isStopping() {
        return stopping;
    }

    @Override
    public void run() {
        try {

            if (isStopping()) {
                return;
            }
            onPrepare();

            if (isStopping()) {
                return;
            }
            try {
                if (isStopping()) {
                    return;
                }

                onStart();

                if (isStopping()) {
                    return;
                }

                Log.i("AppCore", "task(" + tag + ") -> onWorking");
                onWorking();
            } finally {
                onEnd();
            }
        } finally {
            onRelease();
        }
    }

    public abstract void onWorking();

    public void onStart() {
        Log.i("AppCore", "task(" + tag + ") -> onStart");
    }

    public void onEnd() {
        Log.i("AppCore", "task(" + tag + ") -> onEnd");
    }

    public void onPrepare() {
        Log.i("AppCore", "task(" + tag + ") -> onPrepare");
    }

    public void onRelease() {
        Log.i("AppCore", "task(" + tag + ") -> onRelease");
        engine.doFinish(this);
        engine = null;
        tag = null;
    }

}
