/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.support;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.enums.EnableEnum;
import cn.hippo4j.common.executor.support.BlockingQueueTypeEnum;
import cn.hippo4j.common.executor.support.RejectedPolicyTypeEnum;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.model.register.DynamicThreadPoolRegisterParameter;
import cn.hippo4j.common.model.register.DynamicThreadPoolRegisterWrapper;
import cn.hippo4j.common.toolkit.BooleanUtil;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.toolkit.ReflectUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.core.executor.DynamicThreadPool;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.adpter.DynamicThreadPoolAdapterChoose;
import cn.hippo4j.core.toolkit.DynamicThreadPoolAnnotationUtil;
import cn.hippo4j.message.service.GlobalNotifyAlarmManage;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.core.DynamicThreadPoolSubscribeConfig;
import cn.hippo4j.springboot.starter.remote.HttpAgent;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public final class DynamicThreadPoolPostProcessor
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolPostProcessor.class);
    private final BootstrapProperties properties;
    private final HttpAgent httpAgent;
    private final DynamicThreadPoolSubscribeConfig dynamicThreadPoolSubscribeConfig;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DynamicThreadPoolExecutor || DynamicThreadPoolAdapterChoose.match((Object)bean)) {
            try {
                DynamicThreadPool dynamicThreadPool = (DynamicThreadPool)ApplicationContextHolder.findAnnotationOnBean((String)beanName, DynamicThreadPool.class);
                if (Objects.isNull(dynamicThreadPool) && Objects.isNull(dynamicThreadPool = (DynamicThreadPool)DynamicThreadPoolAnnotationUtil.findAnnotationOnBean((String)beanName, DynamicThreadPool.class))) {
                    return bean;
                }
            }
            catch (Exception ex) {
                log.error("Failed to create dynamic thread pool in annotation mode.", (Throwable)ex);
                return bean;
            }
            DynamicThreadPoolExecutor dynamicThreadPoolExecutor = DynamicThreadPoolAdapterChoose.unwrap((Object)bean);
            if (dynamicThreadPoolExecutor == null) {
                dynamicThreadPoolExecutor = (DynamicThreadPoolExecutor)bean;
            }
            DynamicThreadPoolWrapper dynamicThreadPoolWrapper = new DynamicThreadPoolWrapper(dynamicThreadPoolExecutor.getThreadPoolId(), (ThreadPoolExecutor)dynamicThreadPoolExecutor);
            ThreadPoolExecutor remoteThreadPoolExecutor = this.fillPoolAndRegister(dynamicThreadPoolWrapper);
            DynamicThreadPoolAdapterChoose.replace((Object)bean, (Executor)remoteThreadPoolExecutor);
            this.subscribeConfig(dynamicThreadPoolWrapper);
            return DynamicThreadPoolAdapterChoose.match((Object)bean) ? bean : remoteThreadPoolExecutor;
        }
        if (bean instanceof DynamicThreadPoolWrapper) {
            DynamicThreadPoolWrapper dynamicThreadPoolWrapper = (DynamicThreadPoolWrapper)bean;
            this.registerAndSubscribe(dynamicThreadPoolWrapper);
        }
        return bean;
    }

    protected void registerAndSubscribe(DynamicThreadPoolWrapper dynamicThreadPoolWrapper) {
        this.fillPoolAndRegister(dynamicThreadPoolWrapper);
        this.subscribeConfig(dynamicThreadPoolWrapper);
    }

    protected ThreadPoolExecutor fillPoolAndRegister(DynamicThreadPoolWrapper dynamicThreadPoolWrapper) {
        String threadPoolId = dynamicThreadPoolWrapper.getThreadPoolId();
        ThreadPoolExecutor executor = dynamicThreadPoolWrapper.getExecutor();
        HashMap<String, String> queryStrMap = new HashMap<String, String>(3);
        queryStrMap.put("tpId", threadPoolId);
        queryStrMap.put("itemId", this.properties.getItemId());
        queryStrMap.put("namespace", this.properties.getNamespace());
        ThreadPoolParameterInfo threadPoolParameterInfo = new ThreadPoolParameterInfo();
        try {
            Result result = this.httpAgent.httpGetByConfig("/hippo4j/v1/cs/configs", null, queryStrMap, 5000L);
            if (result.isSuccess() && result.getData() != null) {
                String resultJsonStr = JSONUtil.toJSONString((Object)result.getData());
                threadPoolParameterInfo = (ThreadPoolParameterInfo)JSONUtil.parseObject((String)resultJsonStr, ThreadPoolParameterInfo.class);
                if (threadPoolParameterInfo != null) {
                    this.threadPoolParamReplace(executor, threadPoolParameterInfo);
                    this.registerNotifyAlarm(threadPoolParameterInfo);
                }
            } else {
                DynamicThreadPoolRegisterParameter parameterInfo = DynamicThreadPoolRegisterParameter.builder().threadPoolId(threadPoolId).corePoolSize(Integer.valueOf(executor.getCorePoolSize())).maximumPoolSize(Integer.valueOf(executor.getMaximumPoolSize())).blockingQueueType(BlockingQueueTypeEnum.getBlockingQueueTypeEnumByName((String)executor.getQueue().getClass().getSimpleName())).capacity(Integer.valueOf(executor.getQueue().remainingCapacity())).allowCoreThreadTimeOut(Boolean.valueOf(executor.allowsCoreThreadTimeOut())).keepAliveTime(Long.valueOf(executor.getKeepAliveTime(TimeUnit.MILLISECONDS))).isAlarm(Boolean.valueOf(false)).activeAlarm(Integer.valueOf(80)).capacityAlarm(Integer.valueOf(80)).rejectedPolicyType(RejectedPolicyTypeEnum.getRejectedPolicyTypeEnumByName((String)executor.getRejectedExecutionHandler().getClass().getSimpleName())).build();
                DynamicThreadPoolRegisterWrapper registerWrapper = DynamicThreadPoolRegisterWrapper.builder().parameter(parameterInfo).build();
                GlobalThreadPoolManage.dynamicRegister((DynamicThreadPoolRegisterWrapper)registerWrapper);
            }
        }
        catch (Exception ex) {
            log.error("Failed to initialize thread pool configuration. error message: {}", (Object)ex.getMessage());
        }
        GlobalThreadPoolManage.register((String)dynamicThreadPoolWrapper.getThreadPoolId(), (ThreadPoolParameter)threadPoolParameterInfo, (DynamicThreadPoolWrapper)dynamicThreadPoolWrapper);
        return executor;
    }

    private void threadPoolParamReplace(ThreadPoolExecutor executor, ThreadPoolParameterInfo threadPoolParameterInfo) {
        BlockingQueue workQueue = BlockingQueueTypeEnum.createBlockingQueue((int)threadPoolParameterInfo.getQueueType(), (Integer)threadPoolParameterInfo.getCapacity());
        ReflectUtil.setFieldValue((Object)executor, (String)"workQueue", (Object)workQueue);
        executor.setCorePoolSize(threadPoolParameterInfo.corePoolSizeAdapt());
        executor.setMaximumPoolSize(threadPoolParameterInfo.maximumPoolSizeAdapt());
        executor.setKeepAliveTime(threadPoolParameterInfo.getKeepAliveTime().intValue(), TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(EnableEnum.getBool((Integer)threadPoolParameterInfo.getAllowCoreThreadTimeOut()));
        executor.setRejectedExecutionHandler(RejectedPolicyTypeEnum.createPolicy((int)threadPoolParameterInfo.getRejectedType()));
        if (executor instanceof DynamicThreadPoolExecutor) {
            Optional.ofNullable(threadPoolParameterInfo.getExecuteTimeOut()).ifPresent(executeTimeOut -> ((DynamicThreadPoolExecutor)executor).setExecuteTimeOut(executeTimeOut));
        }
    }

    private void registerNotifyAlarm(ThreadPoolParameterInfo threadPoolParameterInfo) {
        ThreadPoolNotifyAlarm threadPoolNotifyAlarm = new ThreadPoolNotifyAlarm(Boolean.valueOf(BooleanUtil.toBoolean((String)threadPoolParameterInfo.getIsAlarm().toString())), threadPoolParameterInfo.getLivenessAlarm(), threadPoolParameterInfo.getCapacityAlarm());
        GlobalNotifyAlarmManage.put((String)threadPoolParameterInfo.getTpId(), (ThreadPoolNotifyAlarm)threadPoolNotifyAlarm);
    }

    protected void subscribeConfig(DynamicThreadPoolWrapper dynamicThreadPoolWrapper) {
        if (dynamicThreadPoolWrapper.isSubscribeFlag()) {
            this.dynamicThreadPoolSubscribeConfig.subscribeConfig(dynamicThreadPoolWrapper.getThreadPoolId());
        }
    }

    @Generated
    public DynamicThreadPoolPostProcessor(BootstrapProperties properties, HttpAgent httpAgent, DynamicThreadPoolSubscribeConfig dynamicThreadPoolSubscribeConfig) {
        this.properties = properties;
        this.httpAgent = httpAgent;
        this.dynamicThreadPoolSubscribeConfig = dynamicThreadPoolSubscribeConfig;
    }
}

