/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.remote;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.design.builder.ThreadFactoryBuilder;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.common.toolkit.http.HttpUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.remote.HttpAgent;
import cn.hippo4j.springboot.starter.remote.ServerHealthCheck;
import cn.hippo4j.springboot.starter.remote.ServerListManager;
import cn.hippo4j.springboot.starter.security.SecurityProxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ServerHttpAgent
implements HttpAgent {
    private final BootstrapProperties dynamicThreadPoolProperties;
    private final ServerListManager serverListManager;
    private SecurityProxy securityProxy;
    private ServerHealthCheck serverHealthCheck;
    private ScheduledExecutorService executorService;
    private final long securityInfoRefreshIntervalMills = TimeUnit.SECONDS.toMillis(5L);

    public ServerHttpAgent(BootstrapProperties properties) {
        this.dynamicThreadPoolProperties = properties;
        this.serverListManager = new ServerListManager(this.dynamicThreadPoolProperties);
        this.securityProxy = new SecurityProxy(properties);
        this.securityProxy.applyToken(this.serverListManager.getServerUrls());
        this.executorService = new ScheduledThreadPoolExecutor((int)new Integer(1), ThreadFactoryBuilder.builder().daemon(true).prefix("client.scheduled.token.security.updater").build());
        this.executorService.scheduleWithFixedDelay(() -> this.securityProxy.applyToken(this.serverListManager.getServerUrls()), 0L, this.securityInfoRefreshIntervalMills, TimeUnit.MILLISECONDS);
    }

    @Override
    public void start() {
    }

    @Override
    public String getTenantId() {
        return this.dynamicThreadPoolProperties.getNamespace();
    }

    @Override
    public String getEncode() {
        return null;
    }

    @Override
    public Result httpGetSimple(String path) {
        path = this.injectSecurityInfoByPath(path);
        return (Result)HttpUtil.get((String)this.buildUrl(path), Result.class);
    }

    @Override
    public Result httpPost(String path, Object body) {
        this.isHealthStatus();
        path = this.injectSecurityInfoByPath(path);
        return (Result)HttpUtil.post((String)this.buildUrl(path), (Object)body, Result.class);
    }

    @Override
    public Result httpPostByDiscovery(String path, Object body) {
        this.isHealthStatus();
        path = this.injectSecurityInfoByPath(path);
        return (Result)HttpUtil.post((String)this.buildUrl(path), (Object)body, Result.class);
    }

    @Override
    public Result httpGetByConfig(String path, Map<String, String> headers, Map<String, String> paramValues, long readTimeoutMs) {
        this.isHealthStatus();
        this.injectSecurityInfo(paramValues);
        return (Result)HttpUtil.get((String)this.buildUrl(path), headers, paramValues, (long)readTimeoutMs, Result.class);
    }

    @Override
    public Result httpPostByConfig(String path, Map<String, String> headers, Map<String, String> paramValues, long readTimeoutMs) {
        this.isHealthStatus();
        this.injectSecurityInfo(paramValues);
        return (Result)HttpUtil.post((String)this.buildUrl(path), headers, paramValues, (long)readTimeoutMs, Result.class);
    }

    @Override
    public Result httpDeleteByConfig(String path, Map<String, String> headers, Map<String, String> paramValues, long readTimeoutMs) {
        return null;
    }

    private String buildUrl(String path) {
        return this.serverListManager.getCurrentServerAddr() + path;
    }

    private void isHealthStatus() {
        if (this.serverHealthCheck == null) {
            this.serverHealthCheck = (ServerHealthCheck)ApplicationContextHolder.getBean(ServerHealthCheck.class);
        }
        this.serverHealthCheck.isHealthStatus();
    }

    private Map injectSecurityInfo(Map<String, String> params) {
        if (StringUtil.isNotBlank((CharSequence)this.securityProxy.getAccessToken())) {
            params.put("accessToken", this.securityProxy.getAccessToken());
        }
        return params;
    }

    @Deprecated
    private String injectSecurityInfoByPath(String path) {
        String resultPath = HttpUtil.buildUrl((String)path, (Map)this.injectSecurityInfo(new HashMap<String, String>()));
        return resultPath;
    }
}

