/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.monitor.send.netty;

import cn.hippo4j.common.monitor.Message;
import cn.hippo4j.common.monitor.MessageWrapper;
import cn.hippo4j.common.toolkit.MessageConvert;
import cn.hippo4j.springboot.starter.monitor.send.MessageSender;
import cn.hippo4j.springboot.starter.monitor.send.netty.SenderHandler;
import cn.hippo4j.springboot.starter.remote.ServerNettyAgent;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.codec.serialization.ObjectDecoder;
import io.netty.handler.codec.serialization.ObjectEncoder;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConnectSender
implements MessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyConnectSender.class);
    private ServerNettyAgent serverNettyAgent;

    @Override
    public void send(Message message) {
        final MessageWrapper messageWrapper = MessageConvert.convert((Message)message);
        EventLoopGroup eventLoopGroup = this.serverNettyAgent.getEventLoopGroup();
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group(eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new ObjectEncoder()});
                    pipeline.addLast(new ChannelHandler[]{new ObjectDecoder(Integer.MAX_VALUE, ClassResolvers.cacheDisabled(null))});
                    pipeline.addLast(new ChannelHandler[]{new SenderHandler(messageWrapper)});
                }
            });
            bootstrap.connect(this.serverNettyAgent.getNettyServerAddress(), this.serverNettyAgent.getNettyServerPort().intValue()).sync();
        }
        catch (Exception e) {
            log.error("Netty send error.", (Throwable)e);
        }
    }

    @Generated
    public NettyConnectSender(ServerNettyAgent serverNettyAgent) {
        this.serverNettyAgent = serverNettyAgent;
    }
}

