/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.monitor;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.design.builder.ThreadFactoryBuilder;
import cn.hippo4j.common.monitor.Message;
import cn.hippo4j.common.spi.DynamicThreadPoolServiceLoader;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.common.toolkit.ThreadUtil;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.monitor.base.MonitorTypeEnum;
import cn.hippo4j.monitor.base.ThreadPoolMonitor;
import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.config.MonitorProperties;
import cn.hippo4j.springboot.starter.monitor.collect.Collector;
import cn.hippo4j.springboot.starter.monitor.send.MessageSender;
import cn.hippo4j.springboot.starter.remote.ServerHealthCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.CommandLineRunner;

public class ReportingEventExecutor
implements Runnable,
CommandLineRunner,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportingEventExecutor.class);
    @NonNull
    private final BootstrapProperties properties;
    @NonNull
    private final MessageSender messageSender;
    @NonNull
    private final ServerHealthCheck serverHealthCheck;
    private Map<String, Collector> collectors;
    private List<ThreadPoolMonitor> threadPoolMonitors;
    private BlockingQueue<Message> messageCollectVessel;
    private ScheduledThreadPoolExecutor collectVesselExecutor;

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Message message = this.messageCollectVessel.take();
                    this.messageSender.send(message);
                }
            }
            catch (Throwable ex) {
                log.error("Consumption buffer container task failed. Number of buffer container tasks: {}", (Object)this.messageCollectVessel.size(), (Object)ex);
                continue;
            }
            break;
        }
    }

    public void run(String ... args) {
        boolean customerDynamicThreadPoolMonitorFlag;
        MonitorProperties monitor = this.properties.getMonitor();
        if (monitor == null || !monitor.getEnable().booleanValue() || StringUtil.isBlank((CharSequence)monitor.getThreadPoolTypes()) || StringUtil.isBlank((CharSequence)monitor.getCollectTypes())) {
            return;
        }
        this.threadPoolMonitors = new ArrayList<ThreadPoolMonitor>();
        String collectType = Optional.ofNullable(StringUtil.emptyToNull((String)monitor.getCollectTypes())).orElse(MonitorTypeEnum.SERVER.name().toLowerCase());
        this.collectVesselExecutor = new ScheduledThreadPoolExecutor((int)new Integer(collectType.split(",").length), ThreadFactoryBuilder.builder().daemon(true).prefix("client.scheduled.collect.data").build());
        Collection dynamicThreadPoolMonitors = DynamicThreadPoolServiceLoader.getSingletonServiceInstances(ThreadPoolMonitor.class);
        Map threadPoolMonitorMap = ApplicationContextHolder.getBeansOfType(ThreadPoolMonitor.class);
        boolean bl = customerDynamicThreadPoolMonitorFlag = CollectionUtil.isNotEmpty((Collection)dynamicThreadPoolMonitors) || CollectionUtil.isNotEmpty((Map)threadPoolMonitorMap);
        if (customerDynamicThreadPoolMonitorFlag) {
            threadPoolMonitorMap.forEach((beanName, bean) -> this.threadPoolMonitors.add((ThreadPoolMonitor)bean));
            dynamicThreadPoolMonitors.forEach(each -> this.threadPoolMonitors.add((ThreadPoolMonitor)each));
            this.collectVesselExecutor.scheduleWithFixedDelay(() -> this.dynamicThreadPoolMonitor(), this.properties.getInitialDelay(), this.properties.getCollectInterval(), TimeUnit.MILLISECONDS);
        }
        if (collectType.contains(MonitorTypeEnum.SERVER.name().toLowerCase())) {
            this.collectVesselExecutor.scheduleWithFixedDelay(() -> this.runTimeGatherTask(), this.properties.getInitialDelay(), this.properties.getCollectInterval(), TimeUnit.MILLISECONDS);
            Integer bufferSize = this.properties.getTaskBufferSize();
            this.messageCollectVessel = new ArrayBlockingQueue<Message>(bufferSize);
            this.collectors = ApplicationContextHolder.getBeansOfType(Collector.class);
            ThreadUtil.newThread((Runnable)this, (String)"client.thread.reporting.task", (boolean)Boolean.TRUE).start();
        }
        if (GlobalThreadPoolManage.getThreadPoolNum() > 0) {
            log.info("Dynamic thread pool: [{}]. The dynamic thread pool starts data collection and reporting.", (Object)GlobalThreadPoolManage.getThreadPoolNum());
        }
    }

    public void destroy() {
        Optional.ofNullable(this.collectVesselExecutor).ifPresent(each -> each.shutdown());
    }

    private void dynamicThreadPoolMonitor() {
        this.threadPoolMonitors.forEach(each -> each.collect());
    }

    private void runTimeGatherTask() {
        boolean healthStatus = this.serverHealthCheck.isHealthStatus();
        if (!healthStatus || CollectionUtil.isEmpty(this.collectors)) {
            return;
        }
        this.collectors.forEach((beanName, collector) -> {
            Message message = collector.collectMessage();
            boolean offer = this.messageCollectVessel.offer(message);
            if (!offer) {
                log.warn("Buffer data starts stacking data...");
            }
        });
    }

    @Generated
    public ReportingEventExecutor(@NonNull BootstrapProperties properties, @NonNull MessageSender messageSender, @NonNull ServerHealthCheck serverHealthCheck) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (messageSender == null) {
            throw new NullPointerException("messageSender is marked non-null but is null");
        }
        if (serverHealthCheck == null) {
            throw new NullPointerException("serverHealthCheck is marked non-null but is null");
        }
        this.properties = properties;
        this.messageSender = messageSender;
        this.serverHealthCheck = serverHealthCheck;
    }
}

