/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.core;

import cn.hippo4j.common.api.NotifyRequest;
import cn.hippo4j.common.api.ThreadPoolConfigChange;
import cn.hippo4j.common.api.ThreadPoolDynamicRefresh;
import cn.hippo4j.common.enums.EnableEnum;
import cn.hippo4j.common.executor.support.BlockingQueueTypeEnum;
import cn.hippo4j.common.executor.support.RejectedPolicyTypeEnum;
import cn.hippo4j.common.executor.support.ResizableCapacityLinkedBlockingQueue;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.message.request.ChangeParameterNotifyRequest;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerThreadPoolDynamicRefresh
implements ThreadPoolDynamicRefresh {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerThreadPoolDynamicRefresh.class);
    private final ThreadPoolConfigChange threadPoolConfigChange;

    public void dynamicRefresh(String content) {
        ThreadPoolParameterInfo parameter = (ThreadPoolParameterInfo)JSONUtil.parseObject((String)content, ThreadPoolParameterInfo.class);
        String threadPoolId = parameter.getTpId();
        ThreadPoolExecutor executor = GlobalThreadPoolManage.getExecutorService((String)threadPoolId).getExecutor();
        this.refreshDynamicPool((ThreadPoolParameter)parameter, executor);
    }

    private void refreshDynamicPool(ThreadPoolParameter parameter, ThreadPoolExecutor executor) {
        String threadPoolId = parameter.getTpId();
        int originalCoreSize = executor.getCorePoolSize();
        int originalMaximumPoolSize = executor.getMaximumPoolSize();
        String originalQuery = executor.getQueue().getClass().getSimpleName();
        int originalCapacity = executor.getQueue().remainingCapacity() + executor.getQueue().size();
        long originalKeepAliveTime = executor.getKeepAliveTime(TimeUnit.SECONDS);
        boolean originalAllowCoreThreadTimeOut = executor.allowsCoreThreadTimeOut();
        Long originalExecuteTimeOut = null;
        RejectedExecutionHandler rejectedExecutionHandler = executor.getRejectedExecutionHandler();
        if (executor instanceof DynamicThreadPoolExecutor) {
            DynamicThreadPoolExecutor dynamicExecutor = (DynamicThreadPoolExecutor)executor;
            rejectedExecutionHandler = dynamicExecutor.getRejectedExecutionHandler();
            originalExecuteTimeOut = dynamicExecutor.getExecuteTimeOut();
        }
        this.changePoolInfo(executor, parameter);
        ThreadPoolExecutor afterExecutor = GlobalThreadPoolManage.getExecutorService((String)threadPoolId).getExecutor();
        String originalRejected = rejectedExecutionHandler.getClass().getSimpleName();
        Long executeTimeOut = Optional.ofNullable(parameter.getExecuteTimeOut()).orElse(0L);
        ChangeParameterNotifyRequest changeNotifyRequest = ChangeParameterNotifyRequest.builder().beforeCorePoolSize(Integer.valueOf(originalCoreSize)).beforeMaximumPoolSize(Integer.valueOf(originalMaximumPoolSize)).beforeAllowsCoreThreadTimeOut(Boolean.valueOf(originalAllowCoreThreadTimeOut)).beforeKeepAliveTime(Long.valueOf(originalKeepAliveTime)).blockingQueueName(originalQuery).beforeQueueCapacity(Integer.valueOf(originalCapacity)).beforeRejectedName(originalRejected).beforeExecuteTimeOut(originalExecuteTimeOut).nowCorePoolSize(Integer.valueOf(afterExecutor.getCorePoolSize())).nowMaximumPoolSize(Integer.valueOf(afterExecutor.getMaximumPoolSize())).nowAllowsCoreThreadTimeOut(Boolean.valueOf(EnableEnum.getBool((Integer)parameter.getAllowCoreThreadTimeOut()))).nowKeepAliveTime(Long.valueOf(afterExecutor.getKeepAliveTime(TimeUnit.SECONDS))).nowQueueCapacity(Integer.valueOf(afterExecutor.getQueue().remainingCapacity() + afterExecutor.getQueue().size())).nowRejectedName(RejectedPolicyTypeEnum.getRejectedNameByType((int)parameter.getRejectedType())).nowExecuteTimeOut(executeTimeOut).build();
        changeNotifyRequest.setThreadPoolId(threadPoolId);
        this.threadPoolConfigChange.sendPoolConfigChange((NotifyRequest)changeNotifyRequest);
        log.info("[{}] Dynamic thread pool change parameter.\n    corePoolSize: {}\n    maximumPoolSize: {}\n    capacity: {}\n    keepAliveTime: {}\n    executeTimeOut: {}\n    rejectedType: {}\n    allowCoreThreadTimeOut: {}", new Object[]{threadPoolId, String.format("%s => %s", originalCoreSize, afterExecutor.getCorePoolSize()), String.format("%s => %s", originalMaximumPoolSize, afterExecutor.getMaximumPoolSize()), String.format("%s => %s", originalCapacity, afterExecutor.getQueue().remainingCapacity() + afterExecutor.getQueue().size()), String.format("%s => %s", originalKeepAliveTime, afterExecutor.getKeepAliveTime(TimeUnit.SECONDS)), String.format("%s => %s", originalExecuteTimeOut, executeTimeOut), String.format("%s => %s", originalRejected, RejectedPolicyTypeEnum.getRejectedNameByType((int)parameter.getRejectedType())), String.format("%s => %s", originalAllowCoreThreadTimeOut, EnableEnum.getBool((Integer)parameter.getAllowCoreThreadTimeOut()))});
    }

    private void changePoolInfo(ThreadPoolExecutor executor, ThreadPoolParameter parameter) {
        if (parameter.getCoreSize() != null && parameter.getMaxSize() != null) {
            if (parameter.getMaxSize() < executor.getMaximumPoolSize()) {
                executor.setCorePoolSize(parameter.getCoreSize());
                executor.setMaximumPoolSize(parameter.getMaxSize());
            } else {
                executor.setMaximumPoolSize(parameter.getMaxSize());
                executor.setCorePoolSize(parameter.getCoreSize());
            }
        } else {
            if (parameter.getMaxSize() != null) {
                executor.setMaximumPoolSize(parameter.getMaxSize());
            }
            if (parameter.getCoreSize() != null) {
                executor.setCorePoolSize(parameter.getCoreSize());
            }
        }
        if (parameter.getCapacity() != null && Objects.equals(BlockingQueueTypeEnum.RESIZABLE_LINKED_BLOCKING_QUEUE.getType(), parameter.getQueueType())) {
            if (executor.getQueue() instanceof ResizableCapacityLinkedBlockingQueue) {
                ResizableCapacityLinkedBlockingQueue queue = (ResizableCapacityLinkedBlockingQueue)executor.getQueue();
                queue.setCapacity(parameter.getCapacity().intValue());
            } else {
                log.warn("The queue length cannot be modified. Queue type mismatch. Current queue type: {}", (Object)executor.getQueue().getClass().getSimpleName());
            }
        }
        if (parameter.getKeepAliveTime() != null) {
            executor.setKeepAliveTime(parameter.getKeepAliveTime().intValue(), TimeUnit.SECONDS);
        }
        Long executeTimeOut = Optional.ofNullable(parameter.getExecuteTimeOut()).orElse(0L);
        if (executor instanceof DynamicThreadPoolExecutor) {
            ((DynamicThreadPoolExecutor)executor).setExecuteTimeOut(executeTimeOut);
        }
        if (parameter.getRejectedType() != null) {
            RejectedExecutionHandler rejectedExecutionHandler = RejectedPolicyTypeEnum.createPolicy((int)parameter.getRejectedType());
            executor.setRejectedExecutionHandler(rejectedExecutionHandler);
        }
        if (parameter.getAllowCoreThreadTimeOut() != null) {
            executor.allowCoreThreadTimeOut(EnableEnum.getBool((Integer)parameter.getAllowCoreThreadTimeOut()));
        }
    }

    @Generated
    public ServerThreadPoolDynamicRefresh(ThreadPoolConfigChange threadPoolConfigChange) {
        this.threadPoolConfigChange = threadPoolConfigChange;
    }
}

