/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.core;

import cn.hippo4j.common.constant.Constants;
import cn.hippo4j.common.design.builder.ThreadFactoryBuilder;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.toolkit.ContentUtil;
import cn.hippo4j.common.toolkit.GroupKey;
import cn.hippo4j.common.toolkit.IdUtil;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.springboot.starter.core.CacheData;
import cn.hippo4j.springboot.starter.core.Listener;
import cn.hippo4j.springboot.starter.remote.HttpAgent;
import cn.hippo4j.springboot.starter.remote.ServerHealthCheck;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ClientWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientWorker.class);
    private long timeout;
    private final HttpAgent agent;
    private final String identify;
    private final ServerHealthCheck serverHealthCheck;
    private final ScheduledExecutorService executor;
    private final ScheduledExecutorService executorService;
    private final CountDownLatch awaitApplicationComplete = new CountDownLatch(1);
    private final CountDownLatch cacheCondition = new CountDownLatch(1);
    private final ConcurrentHashMap<String, CacheData> cacheMap = new ConcurrentHashMap(16);

    public ClientWorker(HttpAgent httpAgent, String identify, ServerHealthCheck serverHealthCheck) {
        this.agent = httpAgent;
        this.identify = identify;
        this.timeout = 30000L;
        this.serverHealthCheck = serverHealthCheck;
        this.executor = Executors.newScheduledThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("client.worker.executor");
            thread.setDaemon(true);
            return thread;
        });
        this.executorService = Executors.newSingleThreadScheduledExecutor(ThreadFactoryBuilder.builder().prefix("client.long.polling.executor").daemon(true).build());
        log.info("Client identify: {}", (Object)identify);
        this.executor.schedule(() -> {
            try {
                this.awaitApplicationComplete.await();
                this.executorService.execute(new LongPollingRunnable(this.cacheMap.isEmpty(), this.cacheCondition));
            }
            catch (Throwable ex) {
                log.error("Sub check rotate check error.", ex);
            }
        }, 1L, TimeUnit.MILLISECONDS);
    }

    private List<String> checkUpdateDataIds(List<CacheData> cacheDataList, List<String> inInitializingCacheList) {
        StringBuilder sb = new StringBuilder();
        for (CacheData cacheData : cacheDataList) {
            sb.append(cacheData.threadPoolId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.itemId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.tenantId).append(Constants.WORD_SEPARATOR);
            sb.append(this.identify).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.getMd5()).append(Constants.LINE_SEPARATOR);
            if (!cacheData.isInitializing()) continue;
            inInitializingCacheList.add(GroupKey.getKeyTenant((String)cacheData.threadPoolId, (String)cacheData.itemId, (String)cacheData.tenantId));
        }
        boolean isInitializingCacheList = !inInitializingCacheList.isEmpty();
        return this.checkUpdateTpIds(sb.toString(), isInitializingCacheList);
    }

    public List<String> checkUpdateTpIds(String probeUpdateString, boolean isInitializingCacheList) {
        if (StringUtils.isEmpty((Object)probeUpdateString)) {
            return Collections.emptyList();
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("Listening-Configs", probeUpdateString);
        params.put("Weight-Configs", IdUtil.simpleUUID());
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("Long-Pulling-Timeout", "" + this.timeout);
        headers.put("Long-Pulling-Client-Identification", this.identify);
        if (isInitializingCacheList) {
            headers.put("Long-Pulling-Timeout-No-Hangup", "true");
        }
        try {
            long readTimeoutMs = this.timeout + (long)Math.round(this.timeout >> 1);
            Result result = this.agent.httpPostByConfig("/hippo4j/v1/cs/configs/listener", headers, params, readTimeoutMs);
            if (result != null && result.isSuccess()) {
                return this.parseUpdateDataIdResponse(result.getData().toString());
            }
        }
        catch (Exception ex) {
            this.setHealthServer(false);
            log.error("Check update get changed dataId exception. error message: {}", (Object)ex.getMessage());
        }
        return Collections.emptyList();
    }

    public String getServerConfig(String namespace, String itemId, String threadPoolId, long readTimeout) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("namespace", namespace);
        params.put("itemId", itemId);
        params.put("tpId", threadPoolId);
        params.put("instanceId", this.identify);
        Result result = this.agent.httpGetByConfig("/hippo4j/v1/cs/configs", null, params, readTimeout);
        if (result.isSuccess()) {
            return JSONUtil.toJSONString((Object)result.getData());
        }
        log.error("Sub server namespace: {}, itemId: {}, threadPoolId: {}, result code: {}", new Object[]{namespace, itemId, threadPoolId, result.getCode()});
        return "";
    }

    public List<String> parseUpdateDataIdResponse(String response) {
        if (StringUtils.isEmpty((Object)response)) {
            return Collections.emptyList();
        }
        try {
            response = URLDecoder.decode(response, "UTF-8");
        }
        catch (Exception e) {
            log.error("Polling resp decode modifiedDataIdsString error.", (Throwable)e);
        }
        LinkedList<String> updateList = new LinkedList<String>();
        for (String dataIdAndGroup : response.split(Constants.LINE_SEPARATOR)) {
            if (StringUtils.isEmpty((Object)dataIdAndGroup)) continue;
            String[] keyArr = dataIdAndGroup.split(Constants.WORD_SEPARATOR);
            String dataId = keyArr[0];
            String group = keyArr[1];
            if (keyArr.length == 3) {
                String tenant = keyArr[2];
                updateList.add(GroupKey.getKeyTenant((String)dataId, (String)group, (String)tenant));
                log.info("[{}] Refresh thread pool changed.", (Object)dataId);
                continue;
            }
            log.error("[{}] Polling resp invalid dataIdAndGroup error.", (Object)dataIdAndGroup);
        }
        return updateList;
    }

    public void addTenantListeners(String namespace, String itemId, String threadPoolId, List<? extends Listener> listeners) {
        CacheData cacheData = this.addCacheDataIfAbsent(namespace, itemId, threadPoolId);
        for (Listener listener : listeners) {
            cacheData.addListener(listener);
        }
        if (this.awaitApplicationComplete.getCount() == 0L) {
            this.cacheCondition.countDown();
        }
    }

    public CacheData addCacheDataIfAbsent(String namespace, String itemId, String threadPoolId) {
        CacheData cacheData = this.cacheMap.get(threadPoolId);
        if (cacheData != null) {
            return cacheData;
        }
        cacheData = new CacheData(namespace, itemId, threadPoolId);
        CacheData lastCacheData = this.cacheMap.putIfAbsent(threadPoolId, cacheData);
        if (lastCacheData == null) {
            try {
                String serverConfig = this.getServerConfig(namespace, itemId, threadPoolId, 3000L);
                ThreadPoolParameterInfo poolInfo = (ThreadPoolParameterInfo)JSONUtil.parseObject((String)serverConfig, ThreadPoolParameterInfo.class);
                cacheData.setContent(ContentUtil.getPoolContent((ThreadPoolParameter)poolInfo));
            }
            catch (Exception ex) {
                log.error("Cache Data Error. Service Unavailable: {}", (Object)ex.getMessage());
            }
            lastCacheData = cacheData;
        }
        return lastCacheData;
    }

    private void setHealthServer(boolean isHealthServer) {
        this.serverHealthCheck.setHealthStatus(isHealthServer);
    }

    public void notifyApplicationComplete() {
        this.awaitApplicationComplete.countDown();
    }

    class LongPollingRunnable
    implements Runnable {
        private boolean cacheMapInitEmptyFlag;
        private final CountDownLatch cacheCondition;

        public LongPollingRunnable(boolean cacheMapInitEmptyFlag, CountDownLatch cacheCondition) {
            this.cacheMapInitEmptyFlag = cacheMapInitEmptyFlag;
            this.cacheCondition = cacheCondition;
        }

        @Override
        public void run() {
            if (this.cacheMapInitEmptyFlag) {
                this.cacheCondition.await();
                this.cacheMapInitEmptyFlag = false;
            }
            ClientWorker.this.serverHealthCheck.isHealthStatus();
            ArrayList cacheDataList = new ArrayList();
            ArrayList inInitializingCacheList = new ArrayList();
            ClientWorker.this.cacheMap.forEach((key, val) -> cacheDataList.add(val));
            List changedTpIds = ClientWorker.this.checkUpdateDataIds(cacheDataList, inInitializingCacheList);
            for (String groupKey : changedTpIds) {
                String[] keys = groupKey.split("\\+");
                String tpId = keys[0];
                String itemId = keys[1];
                String namespace = keys[2];
                try {
                    String content = ClientWorker.this.getServerConfig(namespace, itemId, tpId, 3000L);
                    CacheData cacheData = (CacheData)ClientWorker.this.cacheMap.get(tpId);
                    String poolContent = ContentUtil.getPoolContent((ThreadPoolParameter)((ThreadPoolParameter)JSONUtil.parseObject((String)content, ThreadPoolParameterInfo.class)));
                    cacheData.setContent(poolContent);
                }
                catch (Exception ignored) {
                    log.error("Failed to get the latest thread pool configuration.", (Throwable)ignored);
                }
            }
            for (CacheData cacheData : cacheDataList) {
                if (cacheData.isInitializing() && !inInitializingCacheList.contains(GroupKey.getKeyTenant((String)cacheData.threadPoolId, (String)cacheData.itemId, (String)cacheData.tenantId))) continue;
                cacheData.checkListenerMd5();
                cacheData.setInitializing(false);
            }
            inInitializingCacheList.clear();
            ClientWorker.this.executorService.execute(this);
        }
    }
}

