/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.support;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.enums.EnableEnum;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.toolkit.BooleanUtil;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.core.executor.DynamicThreadPool;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalNotifyAlarmManage;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.executor.support.CommonDynamicThreadPool;
import cn.hippo4j.core.executor.support.QueueTypeEnum;
import cn.hippo4j.core.executor.support.RejectedTypeEnum;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import cn.hippo4j.core.executor.support.adpter.DynamicThreadPoolAdapterChoose;
import cn.hippo4j.core.toolkit.inet.DynamicThreadPoolAnnotationUtil;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.core.DynamicThreadPoolSubscribeConfig;
import cn.hippo4j.springboot.starter.remote.HttpAgent;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.task.TaskDecorator;

public final class DynamicThreadPoolPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolPostProcessor.class);
    private final BootstrapProperties properties;
    private final HttpAgent httpAgent;
    private final DynamicThreadPoolSubscribeConfig dynamicThreadPoolSubscribeConfig;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DynamicThreadPoolExecutor || DynamicThreadPoolAdapterChoose.match((Object)bean)) {
            try {
                DynamicThreadPool dynamicThreadPool = (DynamicThreadPool)ApplicationContextHolder.findAnnotationOnBean((String)beanName, DynamicThreadPool.class);
                if (Objects.isNull(dynamicThreadPool) && Objects.isNull(dynamicThreadPool = (DynamicThreadPool)DynamicThreadPoolAnnotationUtil.findAnnotationOnBean((String)beanName, DynamicThreadPool.class))) {
                    return bean;
                }
            }
            catch (Exception ex) {
                log.error("Failed to create dynamic thread pool in annotation mode.", (Throwable)ex);
                return bean;
            }
            DynamicThreadPoolExecutor dynamicThreadPoolExecutor = DynamicThreadPoolAdapterChoose.unwrap((Object)bean);
            if (dynamicThreadPoolExecutor == null) {
                dynamicThreadPoolExecutor = (DynamicThreadPoolExecutor)bean;
            }
            DynamicThreadPoolWrapper dynamicThreadPoolWrapper = new DynamicThreadPoolWrapper(dynamicThreadPoolExecutor.getThreadPoolId(), (ThreadPoolExecutor)dynamicThreadPoolExecutor);
            ThreadPoolExecutor remoteThreadPoolExecutor = this.fillPoolAndRegister(dynamicThreadPoolWrapper);
            DynamicThreadPoolAdapterChoose.replace((Object)bean, (Executor)remoteThreadPoolExecutor);
            this.subscribeConfig(dynamicThreadPoolWrapper);
            return remoteThreadPoolExecutor;
        }
        if (bean instanceof DynamicThreadPoolWrapper) {
            DynamicThreadPoolWrapper dynamicThreadPoolWrapper = (DynamicThreadPoolWrapper)bean;
            this.registerAndSubscribe(dynamicThreadPoolWrapper);
        }
        return bean;
    }

    protected void registerAndSubscribe(DynamicThreadPoolWrapper dynamicThreadPoolWrapper) {
        this.fillPoolAndRegister(dynamicThreadPoolWrapper);
        this.subscribeConfig(dynamicThreadPoolWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPoolExecutor fillPoolAndRegister(DynamicThreadPoolWrapper dynamicThreadPoolWrapper) {
        String threadPoolId = dynamicThreadPoolWrapper.getThreadPoolId();
        HashMap<String, String> queryStrMap = new HashMap<String, String>(3);
        queryStrMap.put("tpId", threadPoolId);
        queryStrMap.put("itemId", this.properties.getItemId());
        queryStrMap.put("namespace", this.properties.getNamespace());
        boolean isSubscribe = false;
        ThreadPoolExecutor newDynamicThreadPoolExecutor = null;
        ThreadPoolParameterInfo threadPoolParameterInfo = new ThreadPoolParameterInfo();
        try {
            String resultJsonStr;
            Result result = this.httpAgent.httpGetByConfig("/hippo4j/v1/cs/configs", null, queryStrMap, 5000L);
            if (result.isSuccess() && result.getData() != null && (threadPoolParameterInfo = (ThreadPoolParameterInfo)JSONUtil.parseObject((String)(resultJsonStr = JSONUtil.toJSONString((Object)result.getData())), ThreadPoolParameterInfo.class)) != null) {
                BlockingQueue workQueue = QueueTypeEnum.createBlockingQueue((int)threadPoolParameterInfo.getQueueType(), (Integer)threadPoolParameterInfo.getCapacity());
                newDynamicThreadPoolExecutor = ThreadPoolBuilder.builder().dynamicPool().workQueue(workQueue).threadFactory(threadPoolId).poolThreadSize(threadPoolParameterInfo.corePoolSizeAdapt().intValue(), threadPoolParameterInfo.maximumPoolSizeAdapt().intValue()).keepAliveTime((long)threadPoolParameterInfo.getKeepAliveTime().intValue(), TimeUnit.SECONDS).rejected(RejectedTypeEnum.createPolicy((int)threadPoolParameterInfo.getRejectedType())).allowCoreThreadTimeOut(EnableEnum.getBool((Integer)threadPoolParameterInfo.getAllowCoreThreadTimeOut())).build();
                if (dynamicThreadPoolWrapper.getExecutor() instanceof AbstractDynamicExecutorSupport) {
                    ThreadPoolNotifyAlarm threadPoolNotifyAlarm = new ThreadPoolNotifyAlarm(Boolean.valueOf(BooleanUtil.toBoolean((String)threadPoolParameterInfo.getIsAlarm().toString())), threadPoolParameterInfo.getCapacityAlarm(), threadPoolParameterInfo.getLivenessAlarm());
                    GlobalNotifyAlarmManage.put((String)threadPoolId, (ThreadPoolNotifyAlarm)threadPoolNotifyAlarm);
                    TaskDecorator taskDecorator = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrapper.getExecutor()).getTaskDecorator();
                    ((DynamicThreadPoolExecutor)newDynamicThreadPoolExecutor).setTaskDecorator(taskDecorator);
                    long awaitTerminationMillis = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrapper.getExecutor()).awaitTerminationMillis;
                    boolean waitForTasksToCompleteOnShutdown = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrapper.getExecutor()).waitForTasksToCompleteOnShutdown;
                    ((DynamicThreadPoolExecutor)newDynamicThreadPoolExecutor).setSupportParam(awaitTerminationMillis, waitForTasksToCompleteOnShutdown);
                    long executeTimeOut = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrapper.getExecutor()).getExecuteTimeOut();
                    ((DynamicThreadPoolExecutor)newDynamicThreadPoolExecutor).setExecuteTimeOut(Long.valueOf(executeTimeOut));
                }
                dynamicThreadPoolWrapper.setExecutor(newDynamicThreadPoolExecutor);
                isSubscribe = true;
            }
        }
        catch (Exception ex) {
            newDynamicThreadPoolExecutor = dynamicThreadPoolWrapper.getExecutor() != null ? dynamicThreadPoolWrapper.getExecutor() : CommonDynamicThreadPool.getInstance((String)threadPoolId);
            dynamicThreadPoolWrapper.setExecutor(newDynamicThreadPoolExecutor);
            log.error("Failed to initialize thread pool configuration. error message: {}", (Object)ex.getMessage());
        }
        finally {
            if (Objects.isNull(dynamicThreadPoolWrapper.getExecutor())) {
                dynamicThreadPoolWrapper.setExecutor((ThreadPoolExecutor)CommonDynamicThreadPool.getInstance((String)threadPoolId));
            }
            dynamicThreadPoolWrapper.setSubscribeFlag(isSubscribe);
        }
        GlobalThreadPoolManage.register((String)dynamicThreadPoolWrapper.getThreadPoolId(), (ThreadPoolParameter)threadPoolParameterInfo, (DynamicThreadPoolWrapper)dynamicThreadPoolWrapper);
        return newDynamicThreadPoolExecutor;
    }

    protected void subscribeConfig(DynamicThreadPoolWrapper dynamicThreadPoolWrapper) {
        if (dynamicThreadPoolWrapper.isSubscribeFlag()) {
            this.dynamicThreadPoolSubscribeConfig.subscribeConfig(dynamicThreadPoolWrapper.getThreadPoolId());
        }
    }

    public DynamicThreadPoolPostProcessor(BootstrapProperties properties, HttpAgent httpAgent, DynamicThreadPoolSubscribeConfig dynamicThreadPoolSubscribeConfig) {
        this.properties = properties;
        this.httpAgent = httpAgent;
        this.dynamicThreadPoolSubscribeConfig = dynamicThreadPoolSubscribeConfig;
    }
}

