/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.support;

import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.model.register.DynamicThreadPoolRegisterParameter;
import cn.hippo4j.common.model.register.DynamicThreadPoolRegisterWrapper;
import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.common.toolkit.BooleanUtil;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.common.web.exception.ServiceException;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalNotifyAlarmManage;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.service.AbstractDynamicThreadPoolService;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.service.Hippo4jBaseSendMessageService;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.core.ClientWorker;
import cn.hippo4j.springboot.starter.core.DynamicThreadPoolSubscribeConfig;
import cn.hippo4j.springboot.starter.event.ApplicationCompleteEvent;
import cn.hippo4j.springboot.starter.notify.ServerNotifyConfigBuilder;
import cn.hippo4j.springboot.starter.remote.HttpAgent;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class DynamicThreadPoolConfigService
extends AbstractDynamicThreadPoolService
implements ApplicationListener<ApplicationCompleteEvent> {
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolConfigService.class);
    private final HttpAgent httpAgent;
    private final ClientWorker clientWorker;
    private final BootstrapProperties properties;
    private final ServerNotifyConfigBuilder notifyConfigBuilder;
    private final Hippo4jBaseSendMessageService hippo4jBaseSendMessageService;
    private final DynamicThreadPoolSubscribeConfig dynamicThreadPoolSubscribeConfig;

    public ThreadPoolExecutor registerDynamicThreadPool(DynamicThreadPoolRegisterWrapper registerWrapper) {
        ThreadPoolExecutor dynamicThreadPoolExecutor = this.registerExecutor(registerWrapper);
        this.subscribeConfig(registerWrapper);
        this.putNotifyAlarmConfig(registerWrapper);
        return dynamicThreadPoolExecutor;
    }

    public void onApplicationEvent(ApplicationCompleteEvent event) {
        this.clientWorker.notifyApplicationComplete();
    }

    private ThreadPoolExecutor registerExecutor(DynamicThreadPoolRegisterWrapper registerWrapper) {
        DynamicThreadPoolRegisterParameter registerParameter = registerWrapper.getDynamicThreadPoolRegisterParameter();
        this.checkThreadPoolParameter(registerParameter);
        String threadPoolId = registerParameter.getThreadPoolId();
        try {
            this.failDynamicThreadPoolRegisterWrapper(registerWrapper);
            Result registerResult = this.httpAgent.httpPost("/hippo4j/v1/cs/configs/register", registerWrapper);
            if (registerResult == null || !registerResult.isSuccess()) {
                throw new ServiceException("Dynamic thread pool registration returns error.");
            }
        }
        catch (Throwable ex) {
            log.error("Dynamic thread pool registration execution error: {}", (Object)threadPoolId, (Object)ex);
            throw ex;
        }
        ThreadPoolParameterInfo parameter = (ThreadPoolParameterInfo)JSONUtil.parseObject((String)JSONUtil.toJSONString((Object)registerParameter), ThreadPoolParameterInfo.class);
        ThreadPoolExecutor dynamicThreadPoolExecutor = this.buildDynamicThreadPoolExecutor(registerParameter);
        DynamicThreadPoolWrapper dynamicThreadPoolWrapper = DynamicThreadPoolWrapper.builder().threadPoolId(threadPoolId).executor(dynamicThreadPoolExecutor).build();
        GlobalThreadPoolManage.register((String)threadPoolId, (ThreadPoolParameter)parameter, (DynamicThreadPoolWrapper)dynamicThreadPoolWrapper);
        return dynamicThreadPoolExecutor;
    }

    private void subscribeConfig(DynamicThreadPoolRegisterWrapper registerWrapper) {
        this.dynamicThreadPoolSubscribeConfig.subscribeConfig(registerWrapper.getDynamicThreadPoolRegisterParameter().getThreadPoolId());
    }

    private void putNotifyAlarmConfig(DynamicThreadPoolRegisterWrapper registerWrapper) {
        DynamicThreadPoolRegisterParameter registerParameter = registerWrapper.getDynamicThreadPoolRegisterParameter();
        ThreadPoolNotifyAlarm threadPoolNotifyAlarm = new ThreadPoolNotifyAlarm(Boolean.valueOf(BooleanUtil.toBoolean((String)String.valueOf(registerParameter.getIsAlarm()))), registerParameter.getActiveAlarm(), registerParameter.getCapacityAlarm());
        GlobalNotifyAlarmManage.put((String)registerParameter.getThreadPoolId(), (ThreadPoolNotifyAlarm)threadPoolNotifyAlarm);
        Map<String, List<NotifyConfigDTO>> builderNotify = this.notifyConfigBuilder.getAndInitNotify(Lists.newArrayList((Object[])new String[]{registerParameter.getThreadPoolId()}));
        this.hippo4jBaseSendMessageService.putPlatform(builderNotify);
    }

    private void checkThreadPoolParameter(DynamicThreadPoolRegisterParameter registerParameter) {
        Assert.isTrue((!registerParameter.getThreadPoolId().contains("+") ? 1 : 0) != 0, (String)"The thread pool contains sensitive characters.");
    }

    private void failDynamicThreadPoolRegisterWrapper(DynamicThreadPoolRegisterWrapper registerWrapper) {
        registerWrapper.setTenantId(this.properties.getNamespace());
        registerWrapper.setItemId(this.properties.getItemId());
    }

    public DynamicThreadPoolConfigService(HttpAgent httpAgent, ClientWorker clientWorker, BootstrapProperties properties, ServerNotifyConfigBuilder notifyConfigBuilder, Hippo4jBaseSendMessageService hippo4jBaseSendMessageService, DynamicThreadPoolSubscribeConfig dynamicThreadPoolSubscribeConfig) {
        this.httpAgent = httpAgent;
        this.clientWorker = clientWorker;
        this.properties = properties;
        this.notifyConfigBuilder = notifyConfigBuilder;
        this.hippo4jBaseSendMessageService = hippo4jBaseSendMessageService;
        this.dynamicThreadPoolSubscribeConfig = dynamicThreadPoolSubscribeConfig;
    }
}

