/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.notify;

import cn.hippo4j.common.toolkit.GroupKey;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.message.api.NotifyConfigBuilder;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.dto.ThreadPoolNotifyDTO;
import cn.hippo4j.message.request.ThreadPoolNotifyRequest;
import cn.hippo4j.message.service.AlarmControlHandler;
import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.remote.HttpAgent;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerNotifyConfigBuilder
implements NotifyConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(ServerNotifyConfigBuilder.class);
    private final HttpAgent httpAgent;
    private final BootstrapProperties properties;
    private final AlarmControlHandler alarmControlHandler;

    public Map<String, List<NotifyConfigDTO>> buildNotify() {
        List threadPoolIds = GlobalThreadPoolManage.listThreadPoolId();
        if (CollUtil.isEmpty((Collection)threadPoolIds)) {
            log.warn("The client does not have a dynamic thread pool instance configured.");
            return Maps.newHashMap();
        }
        return this.getAndInitNotify(threadPoolIds);
    }

    public Map<String, List<NotifyConfigDTO>> getAndInitNotify(List<String> threadPoolIds) {
        HashMap resultMap = Maps.newHashMap();
        ArrayList groupKeys = Lists.newArrayList();
        threadPoolIds.forEach(each -> {
            String groupKey = GroupKey.getKeyTenant((String)each, (String)this.properties.getItemId(), (String)this.properties.getNamespace());
            groupKeys.add(groupKey);
        });
        Result result = null;
        try {
            result = this.httpAgent.httpPostByDiscovery("/hippo4j/v1/cs/notify/list/config", new ThreadPoolNotifyRequest((List)groupKeys));
        }
        catch (Throwable ex) {
            log.error("Get dynamic thread pool notify configuration error. message: {}", (Object)ex.getMessage());
        }
        if (result != null && result.isSuccess() && result.getData() != null) {
            String resultDataStr = JSONUtil.toJSONString((Object)result.getData());
            List resultData = JSONUtil.parseArray((String)resultDataStr, ThreadPoolNotifyDTO.class);
            resultData.forEach(each -> resultMap.put(each.getNotifyKey(), each.getNotifyList()));
            resultMap.forEach((key, val) -> val.stream().filter(each -> StrUtil.equals((CharSequence)"ALARM", (CharSequence)each.getType())).forEach(each -> this.alarmControlHandler.initCacheAndLock(each.getTpId(), each.getPlatform(), each.getInterval())));
        }
        return resultMap;
    }

    public ServerNotifyConfigBuilder(HttpAgent httpAgent, BootstrapProperties properties, AlarmControlHandler alarmControlHandler) {
        this.httpAgent = httpAgent;
        this.properties = properties;
        this.alarmControlHandler = alarmControlHandler;
    }
}

