/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.core;

import cn.hippo4j.adapter.base.ThreadPoolAdapter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterCacheConfig;
import cn.hippo4j.adapter.base.ThreadPoolAdapterRegisterAction;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.core.toolkit.IdentifyUtil;
import cn.hippo4j.core.toolkit.inet.InetUtils;
import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.remote.HttpAgent;
import cn.hippo4j.springboot.starter.toolkit.CloudCommonIdUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;

public class ThreadPoolAdapterRegister
implements ApplicationRunner,
ThreadPoolAdapterRegisterAction {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolAdapterRegister.class);
    private final HttpAgent httpAgent;
    private final BootstrapProperties properties;
    private final ConfigurableEnvironment environment;
    private final InetUtils hippo4JInetUtils;

    public void run(ApplicationArguments args) throws Exception {
        this.register();
    }

    public List<ThreadPoolAdapterCacheConfig> getThreadPoolAdapterCacheConfigs(Map<String, ThreadPoolAdapter> threadPoolAdapterMap) {
        ArrayList adapterCacheConfigList = Lists.newArrayList();
        for (Map.Entry<String, ThreadPoolAdapter> threadPoolAdapterEntry : threadPoolAdapterMap.entrySet()) {
            ThreadPoolAdapter threadPoolAdapter = threadPoolAdapterEntry.getValue();
            List threadPoolStates = threadPoolAdapter.getThreadPoolStates();
            if (CollectionUtil.isEmpty((List)threadPoolStates) || threadPoolStates.size() == 0) continue;
            ThreadPoolAdapterCacheConfig cacheConfig = new ThreadPoolAdapterCacheConfig();
            cacheConfig.setMark(threadPoolAdapter.mark());
            String tenantItemKey = this.properties.getNamespace() + "_" + this.properties.getItemId();
            cacheConfig.setTenantItemKey(tenantItemKey);
            cacheConfig.setClientIdentify(IdentifyUtil.getIdentify());
            String clientAddress = CloudCommonIdUtil.getClientIpPort((PropertyResolver)this.environment, this.hippo4JInetUtils);
            cacheConfig.setClientAddress(clientAddress);
            cacheConfig.setThreadPoolAdapterStates(threadPoolStates);
            adapterCacheConfigList.add(cacheConfig);
        }
        return adapterCacheConfigList;
    }

    public void doRegister(List<ThreadPoolAdapterCacheConfig> cacheConfigList) {
        if (CollectionUtil.isNotEmpty(cacheConfigList) && cacheConfigList.size() > 0) {
            try {
                Result result = this.httpAgent.httpPost("/hippo4j/v1/cs/adapter/thread-pool/register", cacheConfigList);
                if (!result.isSuccess()) {
                    log.warn("Failed to register third-party thread pool data.");
                }
            }
            catch (Throwable ex) {
                log.error("Failed to register third-party thread pool data.", ex);
            }
        }
    }

    public void register() {
        Map threadPoolAdapterMap = ApplicationContextHolder.getBeansOfType(ThreadPoolAdapter.class);
        List<ThreadPoolAdapterCacheConfig> threadPoolAdapterCacheConfigs = this.getThreadPoolAdapterCacheConfigs(threadPoolAdapterMap);
        this.doRegister(threadPoolAdapterCacheConfigs);
    }

    public ThreadPoolAdapterRegister(HttpAgent httpAgent, BootstrapProperties properties, ConfigurableEnvironment environment, InetUtils hippo4JInetUtils) {
        this.httpAgent = httpAgent;
        this.properties = properties;
        this.environment = environment;
        this.hippo4JInetUtils = hippo4JInetUtils;
    }
}

