/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.core;

import cn.hippo4j.common.api.ThreadPoolDynamicRefresh;
import cn.hippo4j.core.executor.support.QueueTypeEnum;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.core.ClientWorker;
import cn.hippo4j.springboot.starter.core.Listener;
import cn.hippo4j.springboot.starter.core.ThreadPoolSubscribeCallback;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DynamicThreadPoolSubscribeConfig {
    private final ThreadPoolDynamicRefresh threadPoolDynamicRefresh;
    private final ClientWorker clientWorker;
    private final BootstrapProperties properties;
    private final ExecutorService configRefreshExecutorService = ThreadPoolBuilder.builder().corePoolSize(1).maxPoolNum(2).keepAliveTime(2000L).timeUnit(TimeUnit.MILLISECONDS).workQueue(QueueTypeEnum.SYNCHRONOUS_QUEUE).allowCoreThreadTimeOut(true).threadFactory("client.dynamic.threadPool.change.config").rejected((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy()).build();

    public void subscribeConfig(String threadPoolId) {
        this.subscribeConfig(threadPoolId, config -> this.threadPoolDynamicRefresh.dynamicRefresh(config));
    }

    public void subscribeConfig(String threadPoolId, final ThreadPoolSubscribeCallback threadPoolSubscribeCallback) {
        Listener configListener = new Listener(){

            @Override
            public void receiveConfigInfo(String config) {
                threadPoolSubscribeCallback.callback(config);
            }

            @Override
            public Executor getExecutor() {
                return DynamicThreadPoolSubscribeConfig.this.configRefreshExecutorService;
            }
        };
        this.clientWorker.addTenantListeners(this.properties.getNamespace(), this.properties.getItemId(), threadPoolId, Arrays.asList(configListener));
    }

    public DynamicThreadPoolSubscribeConfig(ThreadPoolDynamicRefresh threadPoolDynamicRefresh, ClientWorker clientWorker, BootstrapProperties properties) {
        this.threadPoolDynamicRefresh = threadPoolDynamicRefresh;
        this.clientWorker = clientWorker;
        this.properties = properties;
    }
}

