/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.monitor;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.monitor.Message;
import cn.hippo4j.common.toolkit.ThreadUtil;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.ThreadFactoryBuilder;
import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.monitor.collect.Collector;
import cn.hippo4j.springboot.starter.monitor.send.MessageSender;
import cn.hippo4j.springboot.starter.remote.ServerHealthCheck;
import cn.hutool.core.collection.CollUtil;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.CommandLineRunner;

public class ReportingEventExecutor
implements Runnable,
CommandLineRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ReportingEventExecutor.class);
    @NonNull
    private final BootstrapProperties properties;
    @NonNull
    private final MessageSender messageSender;
    @NonNull
    private final ServerHealthCheck serverHealthCheck;
    private Map<String, Collector> collectors;
    private BlockingQueue<Message> messageCollectVessel;
    private ScheduledThreadPoolExecutor collectVesselExecutor;

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Message message = this.messageCollectVessel.take();
                    this.messageSender.send(message);
                }
            }
            catch (Throwable ex) {
                log.error("Consumption buffer container task failed. Number of buffer container tasks :: {}", (Object)this.messageCollectVessel.size(), (Object)ex);
                continue;
            }
            break;
        }
    }

    public void run(String ... args) {
        if (this.properties.getCollect().booleanValue()) {
            Integer bufferSize = this.properties.getTaskBufferSize();
            this.messageCollectVessel = new ArrayBlockingQueue<Message>(bufferSize);
            String collectVesselTaskName = "client.scheduled.collect.data";
            this.collectVesselExecutor = new ScheduledThreadPoolExecutor((int)new Integer(1), ThreadFactoryBuilder.builder().daemon(true).prefix(collectVesselTaskName).build());
            this.collectVesselExecutor.scheduleWithFixedDelay(() -> this.runTimeGatherTask(), this.properties.getInitialDelay(), this.properties.getCollectInterval(), TimeUnit.MILLISECONDS);
            String reportingTaskName = "client.thread.reporting.task";
            ThreadUtil.newThread((Runnable)this, (String)reportingTaskName, (boolean)Boolean.TRUE).start();
            this.collectors = ApplicationContextHolder.getBeansOfType(Collector.class);
        }
        log.info("Dynamic thread pool :: [{}]. The dynamic thread pool starts data collection and reporting. ", (Object)GlobalThreadPoolManage.getThreadPoolNum());
    }

    public void destroy() {
        Optional.ofNullable(this.collectVesselExecutor).ifPresent(each -> each.shutdown());
    }

    private void runTimeGatherTask() {
        boolean healthStatus = this.serverHealthCheck.isHealthStatus();
        if (!healthStatus || CollUtil.isEmpty(this.collectors)) {
            return;
        }
        this.collectors.forEach((beanName, collector) -> {
            Message message = collector.collectMessage();
            boolean offer = this.messageCollectVessel.offer(message);
            if (!offer) {
                log.warn("Buffer data starts stacking data...");
            }
        });
    }

    public ReportingEventExecutor(@NonNull BootstrapProperties properties, @NonNull MessageSender messageSender, @NonNull ServerHealthCheck serverHealthCheck) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (messageSender == null) {
            throw new NullPointerException("messageSender is marked non-null but is null");
        }
        if (serverHealthCheck == null) {
            throw new NullPointerException("serverHealthCheck is marked non-null but is null");
        }
        this.properties = properties;
        this.messageSender = messageSender;
        this.serverHealthCheck = serverHealthCheck;
    }
}

