/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.core;

import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.core.ConfigService;
import cn.hippo4j.springboot.starter.core.Listener;
import cn.hippo4j.springboot.starter.core.ThreadPoolSubscribeCallback;
import java.util.concurrent.Executor;

public class ThreadPoolOperation {
    private final ConfigService configService;
    private final BootstrapProperties properties;

    public ThreadPoolOperation(BootstrapProperties properties, ConfigService configService) {
        this.properties = properties;
        this.configService = configService;
    }

    public Listener subscribeConfig(String tpId, final Executor executor, final ThreadPoolSubscribeCallback threadPoolSubscribeCallback) {
        Listener configListener = new Listener(){

            @Override
            public void receiveConfigInfo(String config) {
                threadPoolSubscribeCallback.callback(config);
            }

            @Override
            public Executor getExecutor() {
                return executor;
            }
        };
        this.configService.addListener(this.properties.getNamespace(), this.properties.getItemId(), tpId, configListener);
        return configListener;
    }
}

