/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.core;

import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.toolkit.ContentUtil;
import cn.hippo4j.common.toolkit.Md5Util;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.springboot.starter.core.Listener;
import cn.hippo4j.springboot.starter.wrapper.ManagerListenerWrapper;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheData {
    private static final Logger log = LoggerFactory.getLogger(CacheData.class);
    public volatile String md5;
    public volatile String content;
    public final String tenantId;
    public final String itemId;
    public final String tpId;
    private int taskId;
    private volatile boolean isInitializing = true;
    private volatile long localConfigLastModified;
    private final CopyOnWriteArrayList<ManagerListenerWrapper> listeners;

    public CacheData(String tenantId, String itemId, String tpId) {
        this.tenantId = tenantId;
        this.itemId = itemId;
        this.tpId = tpId;
        this.content = ContentUtil.getPoolContent((ThreadPoolParameter)GlobalThreadPoolManage.getPoolParameter((String)tpId));
        this.md5 = CacheData.getMd5String(this.content);
        this.listeners = new CopyOnWriteArrayList();
    }

    public void addListener(Listener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("Listener is null.");
        }
        ManagerListenerWrapper managerListenerWrap = new ManagerListenerWrapper(this.md5, listener);
        if (this.listeners.addIfAbsent(managerListenerWrap)) {
            log.info("Add listener status :: ok, thread pool id :: {}, listeners count :: {}", (Object)this.tpId, (Object)this.listeners.size());
        }
    }

    public void checkListenerMd5() {
        for (ManagerListenerWrapper wrap : this.listeners) {
            if (this.md5.equals(wrap.getLastCallMd5())) continue;
            this.safeNotifyListener(this.content, this.md5, wrap);
        }
    }

    private void safeNotifyListener(String content, String md5, ManagerListenerWrapper wrap) {
        Listener listener = wrap.getListener();
        Runnable runnable = () -> {
            wrap.setLastCallMd5(md5);
            listener.receiveConfigInfo(content);
        };
        try {
            listener.getExecutor().execute(runnable);
        }
        catch (Exception ex) {
            log.error("Failed to execute listener. message :: {}", (Object)ex.getMessage());
        }
    }

    public void setContent(String content) {
        this.content = content;
        this.md5 = CacheData.getMd5String(this.content);
    }

    public static String getMd5String(String config) {
        return null == config ? "" : Md5Util.md5Hex((String)config, (String)"UTF-8");
    }

    public String getMd5() {
        return this.md5;
    }

    public void setTaskId(Integer taskId) {
        this.taskId = taskId;
    }

    public boolean isInitializing() {
        return this.isInitializing;
    }

    public void setInitializing(boolean isInitializing) {
        this.isInitializing = isInitializing;
    }
}

