/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import cn.hippo4j.common.api.ThreadPoolDynamicRefresh;
import cn.hippo4j.common.enums.EnableEnum;
import cn.hippo4j.common.model.PoolParameter;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.common.notify.request.ChangeParameterNotifyRequest;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.ThreadPoolNotifyAlarmHandler;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.executor.support.QueueTypeEnum;
import cn.hippo4j.core.executor.support.RejectedTypeEnum;
import cn.hippo4j.core.executor.support.ResizableCapacityLinkedBlockIngQueue;
import cn.hippo4j.core.proxy.RejectedProxyUtil;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerThreadPoolDynamicRefresh
implements ThreadPoolDynamicRefresh {
    private static final Logger log = LoggerFactory.getLogger(ServerThreadPoolDynamicRefresh.class);
    private final ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler;

    public void dynamicRefresh(String content) {
        PoolParameterInfo parameter = (PoolParameterInfo)JSONUtil.parseObject((String)content, PoolParameterInfo.class);
        String threadPoolId = parameter.getTpId();
        ThreadPoolExecutor executor = GlobalThreadPoolManage.getExecutorService((String)threadPoolId).getExecutor();
        this.refreshDynamicPool((PoolParameter)parameter, executor);
    }

    public void refreshDynamicPool(PoolParameter parameter, ThreadPoolExecutor executor) {
        String threadPoolId = parameter.getTpId();
        int originalCoreSize = executor.getCorePoolSize();
        int originalMaximumPoolSize = executor.getMaximumPoolSize();
        String originalQuery = executor.getQueue().getClass().getSimpleName();
        int originalCapacity = executor.getQueue().remainingCapacity() + executor.getQueue().size();
        long originalKeepAliveTime = executor.getKeepAliveTime(TimeUnit.SECONDS);
        boolean originalAllowCoreThreadTimeOut = executor.allowsCoreThreadTimeOut();
        Long originalExecuteTimeOut = null;
        RejectedExecutionHandler rejectedExecutionHandler = executor.getRejectedExecutionHandler();
        if (executor instanceof AbstractDynamicExecutorSupport) {
            DynamicThreadPoolExecutor dynamicExecutor = (DynamicThreadPoolExecutor)executor;
            rejectedExecutionHandler = dynamicExecutor.getRedundancyHandler();
            originalExecuteTimeOut = dynamicExecutor.getExecuteTimeOut();
        }
        String originalRejected = rejectedExecutionHandler.getClass().getSimpleName();
        ChangeParameterNotifyRequest request = new ChangeParameterNotifyRequest();
        request.setBeforeCorePoolSize(Integer.valueOf(originalCoreSize));
        request.setBeforeMaximumPoolSize(Integer.valueOf(originalMaximumPoolSize));
        request.setBeforeAllowsCoreThreadTimeOut(Boolean.valueOf(originalAllowCoreThreadTimeOut));
        request.setBeforeKeepAliveTime(Long.valueOf(originalKeepAliveTime));
        request.setBlockingQueueName(originalQuery);
        request.setBeforeQueueCapacity(Integer.valueOf(originalCapacity));
        request.setBeforeRejectedName(originalRejected);
        request.setBeforeExecuteTimeOut(originalExecuteTimeOut);
        request.setThreadPoolId(threadPoolId);
        this.changePoolInfo(executor, parameter);
        ThreadPoolExecutor afterExecutor = GlobalThreadPoolManage.getExecutorService((String)threadPoolId).getExecutor();
        request.setNowCorePoolSize(Integer.valueOf(afterExecutor.getCorePoolSize()));
        request.setNowMaximumPoolSize(Integer.valueOf(afterExecutor.getMaximumPoolSize()));
        request.setNowAllowsCoreThreadTimeOut(Boolean.valueOf(EnableEnum.getBool((Integer)parameter.getAllowCoreThreadTimeOut())));
        request.setNowKeepAliveTime(Long.valueOf(afterExecutor.getKeepAliveTime(TimeUnit.SECONDS)));
        request.setNowQueueCapacity(Integer.valueOf(afterExecutor.getQueue().remainingCapacity() + afterExecutor.getQueue().size()));
        request.setNowRejectedName(RejectedTypeEnum.getRejectedNameByType((int)parameter.getRejectedType()));
        request.setNowExecuteTimeOut(originalExecuteTimeOut);
        this.threadPoolNotifyAlarmHandler.sendPoolConfigChange(request);
        log.info("[{}] Changed thread pool. \n    coreSize :: [{}]\n    maxSize :: [{}]\n    queueType :: [{}]\n    capacity :: [{}]\n    keepAliveTime :: [{}]\n    executeTimeOut :: [{}]\n    rejectedType :: [{}]\n    allowCoreThreadTimeOut :: [{}]", new Object[]{threadPoolId.toUpperCase(), String.format("%s => %s", originalCoreSize, afterExecutor.getCorePoolSize()), String.format("%s => %s", originalMaximumPoolSize, afterExecutor.getMaximumPoolSize()), String.format("%s => %s", originalQuery, QueueTypeEnum.getBlockingQueueNameByType((int)parameter.getQueueType())), String.format("%s => %s", originalCapacity, afterExecutor.getQueue().remainingCapacity() + afterExecutor.getQueue().size()), String.format("%s => %s", originalKeepAliveTime, afterExecutor.getKeepAliveTime(TimeUnit.SECONDS)), String.format("%s => %s", originalExecuteTimeOut, originalExecuteTimeOut), String.format("%s => %s", originalRejected, RejectedTypeEnum.getRejectedNameByType((int)parameter.getRejectedType())), String.format("%s => %s", originalAllowCoreThreadTimeOut, EnableEnum.getBool((Integer)parameter.getAllowCoreThreadTimeOut()))});
    }

    public void changePoolInfo(ThreadPoolExecutor executor, PoolParameter parameter) {
        if (parameter.getCoreSize() != null) {
            executor.setCorePoolSize(parameter.getCoreSize());
        }
        if (parameter.getMaxSize() != null) {
            executor.setMaximumPoolSize(parameter.getMaxSize());
        }
        if (parameter.getCapacity() != null && Objects.equals(QueueTypeEnum.RESIZABLE_LINKED_BLOCKING_QUEUE.type, parameter.getQueueType())) {
            if (executor.getQueue() instanceof ResizableCapacityLinkedBlockIngQueue) {
                ResizableCapacityLinkedBlockIngQueue queue = (ResizableCapacityLinkedBlockIngQueue)executor.getQueue();
                queue.setCapacity(parameter.getCapacity());
            } else {
                log.warn("The queue length cannot be modified. Queue type mismatch. Current queue type :: {}", (Object)executor.getQueue().getClass().getSimpleName());
            }
        }
        if (parameter.getKeepAliveTime() != null) {
            executor.setKeepAliveTime(parameter.getKeepAliveTime().intValue(), TimeUnit.SECONDS);
        }
        if (parameter.getRejectedType() != null) {
            RejectedExecutionHandler rejectedExecutionHandler = RejectedTypeEnum.createPolicy((int)parameter.getRejectedType());
            if (executor instanceof AbstractDynamicExecutorSupport) {
                DynamicThreadPoolExecutor dynamicExecutor = (DynamicThreadPoolExecutor)executor;
                dynamicExecutor.setRedundancyHandler(rejectedExecutionHandler);
                AtomicLong rejectCount = dynamicExecutor.getRejectCount();
                rejectedExecutionHandler = RejectedProxyUtil.createProxy((RejectedExecutionHandler)rejectedExecutionHandler, (String)parameter.getTpId(), (AtomicLong)rejectCount);
            }
            executor.setRejectedExecutionHandler(rejectedExecutionHandler);
        }
        if (parameter.getAllowCoreThreadTimeOut() != null) {
            executor.allowCoreThreadTimeOut(EnableEnum.getBool((Integer)parameter.getAllowCoreThreadTimeOut()));
        }
    }

    public ServerThreadPoolDynamicRefresh(ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler) {
        this.threadPoolNotifyAlarmHandler = threadPoolNotifyAlarmHandler;
    }
}

