/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import cn.hippo4j.common.api.ThreadDetailState;
import cn.hippo4j.common.model.ThreadDetailStateInfo;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.ReflectUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseThreadDetailStateHandler
implements ThreadDetailState {
    private static final Logger log = LoggerFactory.getLogger(BaseThreadDetailStateHandler.class);
    private final String WORKERS = "workers";
    private final String THREAD = "thread";

    public List<ThreadDetailStateInfo> getThreadDetailStateInfo(String threadPoolId) {
        DynamicThreadPoolWrapper poolWrapper = GlobalThreadPoolManage.getExecutorService((String)threadPoolId);
        ThreadPoolExecutor executor = poolWrapper.getExecutor();
        return this.getThreadDetailStateInfo(executor);
    }

    public List<ThreadDetailStateInfo> getThreadDetailStateInfo(ThreadPoolExecutor threadPoolExecutor) {
        ArrayList<ThreadDetailStateInfo> resultThreadState = new ArrayList<ThreadDetailStateInfo>();
        try {
            HashSet workers = (HashSet)ReflectUtil.getFieldValue((Object)threadPoolExecutor, (String)"workers");
            if (CollectionUtil.isEmpty((Collection)workers)) {
                return resultThreadState;
            }
            for (Object worker : workers) {
                Thread thread;
                block8: {
                    try {
                        thread = (Thread)ReflectUtil.getFieldValue(worker, (String)"thread");
                        if (thread == null) {
                            log.warn("Reflection get worker thread is null. Worker :: {}", worker);
                        }
                        break block8;
                    }
                    catch (Exception ex) {
                        log.error("Reflection get worker thread exception. Worker :: {}", worker, (Object)ex);
                    }
                    continue;
                }
                long threadId = thread.getId();
                String threadName = thread.getName();
                String threadStatus = thread.getState().name();
                StackTraceElement[] stackTrace = thread.getStackTrace();
                ArrayList<String> stacks = new ArrayList<String>(stackTrace.length);
                for (int i = 0; i < stackTrace.length; ++i) {
                    stacks.add(stackTrace[i].toString());
                }
                ThreadDetailStateInfo threadState = new ThreadDetailStateInfo();
                threadState.setThreadId(Long.valueOf(threadId)).setThreadName(threadName).setThreadStatus(threadStatus).setThreadStack(stacks);
                resultThreadState.add(threadState);
            }
        }
        catch (Exception ex) {
            log.error("Failed to get thread status.", (Throwable)ex);
        }
        return resultThreadState;
    }
}

