/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.controller;

import cn.hippo4j.common.model.PoolBaseInfo;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.common.model.PoolRunStateInfo;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.common.web.base.Results;
import cn.hippo4j.core.executor.web.WebThreadPoolHandlerChoose;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
public class WebThreadPoolController {
    private final WebThreadPoolHandlerChoose webThreadPoolServiceChoose;

    @GetMapping(value={"/web/base/info"})
    public Result<PoolBaseInfo> getPoolBaseState() {
        PoolBaseInfo poolBaseInfo = this.webThreadPoolServiceChoose.choose().simpleInfo();
        return Results.success((Object)poolBaseInfo);
    }

    @GetMapping(value={"/web/run/state"})
    public Result<PoolRunStateInfo> getPoolRunState() {
        PoolRunStateInfo poolRunState = this.webThreadPoolServiceChoose.choose().getWebRunStateInfo();
        return Results.success((Object)poolRunState);
    }

    @PostMapping(value={"/web/update/pool"})
    public Result<Void> updateWebThreadPool(@RequestBody PoolParameterInfo poolParameterInfo) {
        this.webThreadPoolServiceChoose.choose().updateWebThreadPool(poolParameterInfo);
        return Results.success();
    }

    public WebThreadPoolController(WebThreadPoolHandlerChoose webThreadPoolServiceChoose) {
        this.webThreadPoolServiceChoose = webThreadPoolServiceChoose;
    }
}

