/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.security;

import cn.hippo4j.common.model.TokenInfo;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.toolkit.HttpClientUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityProxy {
    private static final Logger log = LoggerFactory.getLogger(SecurityProxy.class);
    private static final String APPLY_TOKEN_URL = "/hippo4j/v1/cs/auth/users/apply/token";
    private final HttpClientUtil httpClientUtil;
    private final String username;
    private final String password;
    private String accessToken;
    private long tokenTtl;
    private long lastRefreshTime;
    private long tokenRefreshWindow;

    public SecurityProxy(HttpClientUtil httpClientUtil, BootstrapProperties properties) {
        this.username = properties.getUsername();
        this.password = properties.getPassword();
        this.httpClientUtil = httpClientUtil;
    }

    public boolean applyToken(List<String> servers) {
        try {
            if (System.currentTimeMillis() - this.lastRefreshTime < TimeUnit.SECONDS.toMillis(this.tokenTtl - this.tokenRefreshWindow)) {
                return true;
            }
            for (String server : servers) {
                if (!this.applyToken(server)) continue;
                this.lastRefreshTime = System.currentTimeMillis();
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean applyToken(String server) {
        if (StringUtil.isAllNotEmpty((CharSequence[])new CharSequence[]{this.username, this.password})) {
            String url = server + APPLY_TOKEN_URL;
            HashMap<String, String> bodyMap = new HashMap<String, String>(2);
            bodyMap.put("userName", this.username);
            bodyMap.put("password", this.password);
            try {
                Result result = this.httpClientUtil.restApiPost(url, bodyMap, Result.class);
                if (!result.isSuccess()) {
                    log.error("Error getting access token. message :: {}", (Object)result.getMessage());
                    return false;
                }
                String tokenJsonStr = JSONUtil.toJSONString((Object)result.getData());
                TokenInfo tokenInfo = (TokenInfo)JSONUtil.parseObject((String)tokenJsonStr, TokenInfo.class);
                this.accessToken = tokenInfo.getAccessToken();
                this.tokenTtl = tokenInfo.getTokenTtl();
                this.tokenRefreshWindow = this.tokenTtl / 10L;
            }
            catch (Throwable ex) {
                log.error("Failed to apply for token. message :: {}", (Object)ex.getMessage());
                return false;
            }
        }
        return true;
    }

    public String getAccessToken() {
        return this.accessToken;
    }
}

