/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.handler.web;

import cn.hippo4j.common.model.PoolBaseInfo;
import cn.hippo4j.common.model.PoolRunStateInfo;
import cn.hippo4j.starter.handler.AbstractThreadPoolRuntime;
import cn.hippo4j.starter.toolkit.ByteConvertUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.RuntimeInfo;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WebThreadPoolRunStateHandler
extends AbstractThreadPoolRuntime {
    @Override
    public PoolBaseInfo simpleInfo(Executor executor) {
        PoolBaseInfo poolBaseInfo = new PoolBaseInfo();
        if (executor != null && executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
            int corePoolSize = threadPoolExecutor.getCorePoolSize();
            int maximumPoolSize = threadPoolExecutor.getMaximumPoolSize();
            RejectedExecutionHandler rejectedExecutionHandler = threadPoolExecutor.getRejectedExecutionHandler();
            long keepAliveTime = threadPoolExecutor.getKeepAliveTime(TimeUnit.SECONDS);
            BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
            int queueSize = queue.size();
            int remainingCapacity = queue.remainingCapacity();
            int queueCapacity = queueSize + remainingCapacity;
            poolBaseInfo.setCoreSize(Integer.valueOf(corePoolSize));
            poolBaseInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
            poolBaseInfo.setKeepAliveTime(Long.valueOf(keepAliveTime));
            poolBaseInfo.setQueueType(queue.getClass().getSimpleName());
            poolBaseInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
            poolBaseInfo.setRejectedName(rejectedExecutionHandler.getClass().getSimpleName());
        }
        return poolBaseInfo;
    }

    @Override
    protected PoolRunStateInfo supplement(PoolRunStateInfo poolRunStateInfo) {
        RuntimeInfo runtimeInfo = new RuntimeInfo();
        String memoryProportion = StrUtil.builder((CharSequence[])new CharSequence[]{"\u5df2\u5206\u914d: ", ByteConvertUtil.getPrintSize(runtimeInfo.getTotalMemory()), " / \u6700\u5927\u53ef\u7528: ", ByteConvertUtil.getPrintSize(runtimeInfo.getMaxMemory())}).toString();
        poolRunStateInfo.setCurrentLoad(poolRunStateInfo.getCurrentLoad() + "%");
        poolRunStateInfo.setPeakLoad(poolRunStateInfo.getPeakLoad() + "%");
        poolRunStateInfo.setMemoryProportion(memoryProportion);
        poolRunStateInfo.setFreeMemory(ByteConvertUtil.getPrintSize(runtimeInfo.getFreeMemory()));
        return poolRunStateInfo;
    }
}

