/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.handler.web;

import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.starter.handler.web.AbstractWebThreadPoolService;
import io.undertow.Undertow;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.util.ReflectionUtils;
import org.xnio.Options;
import org.xnio.XnioWorker;

public class UndertowWebThreadPoolHandler
extends AbstractWebThreadPoolService {
    private static final Logger log = LoggerFactory.getLogger(UndertowWebThreadPoolHandler.class);
    private static final String UNDERTOW_NAME = "undertow";

    @Override
    protected Executor getWebThreadPoolByServer(WebServer webServer) {
        UndertowWebServer undertowWebServer = (UndertowWebServer)webServer;
        Field undertowField = ReflectionUtils.findField(UndertowWebServer.class, (String)UNDERTOW_NAME);
        ReflectionUtils.makeAccessible((Field)undertowField);
        Undertow undertow = (Undertow)ReflectionUtils.getField((Field)undertowField, (Object)undertowWebServer);
        return Objects.isNull(undertow) ? null : undertow.getWorker();
    }

    @Override
    public void updateWebThreadPool(PoolParameterInfo poolParameterInfo) {
        try {
            XnioWorker xnioWorker = (XnioWorker)this.executor;
            Integer coreSize = poolParameterInfo.getCoreSize();
            Integer maxSize = poolParameterInfo.getMaxSize();
            Integer keepAliveTime = poolParameterInfo.getKeepAliveTime();
            int originalCoreSize = (Integer)xnioWorker.getOption(Options.WORKER_TASK_CORE_THREADS);
            int originalMaximumPoolSize = (Integer)xnioWorker.getOption(Options.WORKER_TASK_MAX_THREADS);
            int originalKeepAliveTime = (Integer)xnioWorker.getOption(Options.WORKER_TASK_KEEPALIVE);
            xnioWorker.setOption(Options.WORKER_TASK_CORE_THREADS, (Object)coreSize);
            xnioWorker.setOption(Options.WORKER_TASK_MAX_THREADS, (Object)maxSize);
            xnioWorker.setOption(Options.WORKER_TASK_KEEPALIVE, (Object)keepAliveTime);
            log.info("\ud83d\udd25 Changed web thread pool. coreSize :: [{}], maxSize :: [{}], keepAliveTime :: [{}]", new Object[]{String.format("%s => %s", originalCoreSize, coreSize), String.format("%s => %s", originalMaximumPoolSize, maxSize), String.format("%s => %s", originalKeepAliveTime, keepAliveTime)});
        }
        catch (Exception ex) {
            log.error("Failed to modify the undertow thread pool parameter.", (Throwable)ex);
        }
    }
}

