/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.handler.web;

import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.starter.handler.web.AbstractWebThreadPoolService;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.jetty.JettyWebServer;
import org.springframework.boot.web.server.WebServer;

public class JettyWebThreadPoolHandler
extends AbstractWebThreadPoolService {
    private static final Logger log = LoggerFactory.getLogger(JettyWebThreadPoolHandler.class);

    @Override
    protected Executor getWebThreadPoolByServer(WebServer webServer) {
        JettyWebServer jettyWebServer = (JettyWebServer)webServer;
        return jettyWebServer.getServer().getThreadPool();
    }

    @Override
    public void updateWebThreadPool(PoolParameterInfo poolParameterInfo) {
        try {
            ThreadPool.SizedThreadPool jettyExecutor = (ThreadPool.SizedThreadPool)this.executor;
            Integer coreSize = poolParameterInfo.getCoreSize();
            Integer maxSize = poolParameterInfo.getMaxSize();
            jettyExecutor.setMinThreads(coreSize.intValue());
            jettyExecutor.setMaxThreads(maxSize.intValue());
            log.info("\ud83d\udd25 Changed web thread pool. coreSize :: [{}], maxSize :: [{}]", (Object)String.format("%s => %s", jettyExecutor.getMinThreads(), coreSize), (Object)String.format("%s => %s", jettyExecutor.getMaxThreads(), maxSize));
        }
        catch (Exception ex) {
            log.error("Failed to modify the jetty thread pool parameter.", (Throwable)ex);
        }
    }
}

