/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.handler.web;

import cn.hippo4j.common.model.PoolBaseInfo;
import cn.hippo4j.common.model.PoolRunStateInfo;
import cn.hippo4j.common.toolkit.ReflectUtil;
import cn.hippo4j.starter.handler.AbstractThreadPoolRuntime;
import cn.hippo4j.starter.toolkit.ByteConvertUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.RuntimeInfo;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Options;
import org.xnio.XnioWorker;

public class WebThreadPoolRunStateHandler
extends AbstractThreadPoolRuntime {
    private static final Logger log = LoggerFactory.getLogger(WebThreadPoolRunStateHandler.class);

    @Override
    public PoolBaseInfo simpleInfo(Executor executor) {
        PoolBaseInfo poolBaseInfo = new PoolBaseInfo();
        if (executor != null && executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
            int corePoolSize = threadPoolExecutor.getCorePoolSize();
            int maximumPoolSize = threadPoolExecutor.getMaximumPoolSize();
            RejectedExecutionHandler rejectedExecutionHandler = threadPoolExecutor.getRejectedExecutionHandler();
            long keepAliveTime = threadPoolExecutor.getKeepAliveTime(TimeUnit.SECONDS);
            BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
            int queueSize = queue.size();
            int remainingCapacity = queue.remainingCapacity();
            int queueCapacity = queueSize + remainingCapacity;
            poolBaseInfo.setCoreSize(Integer.valueOf(corePoolSize));
            poolBaseInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
            poolBaseInfo.setKeepAliveTime(Long.valueOf(keepAliveTime));
            poolBaseInfo.setQueueType(queue.getClass().getSimpleName());
            poolBaseInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
            poolBaseInfo.setRejectedName(rejectedExecutionHandler.getClass().getSimpleName());
        } else if (Objects.equals("QueuedThreadPool", executor.getClass().getSimpleName())) {
            QueuedThreadPool queuedThreadPool = (QueuedThreadPool)executor;
            poolBaseInfo.setCoreSize(Integer.valueOf(queuedThreadPool.getMinThreads()));
            poolBaseInfo.setMaximumSize(Integer.valueOf(queuedThreadPool.getMaxThreads()));
            BlockingQueue jobs = (BlockingQueue)ReflectUtil.getFieldValue((Object)queuedThreadPool, (String)"_jobs");
            int queueCapacity = jobs.remainingCapacity() + jobs.size();
            poolBaseInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
            poolBaseInfo.setQueueType(jobs.getClass().getSimpleName());
            poolBaseInfo.setKeepAliveTime(Long.valueOf(queuedThreadPool.getIdleTimeout()));
            poolBaseInfo.setRejectedName("RejectedExecutionException");
        } else if (Objects.equals("NioXnioWorker", executor.getClass().getSimpleName())) {
            XnioWorker xnioWorker = (XnioWorker)executor;
            try {
                int coreSize = (Integer)xnioWorker.getOption(Options.WORKER_TASK_CORE_THREADS);
                int maximumPoolSize = (Integer)xnioWorker.getOption(Options.WORKER_TASK_MAX_THREADS);
                int keepAliveTime = (Integer)xnioWorker.getOption(Options.WORKER_TASK_KEEPALIVE);
                poolBaseInfo.setCoreSize(Integer.valueOf(coreSize));
                poolBaseInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
                poolBaseInfo.setKeepAliveTime(Long.valueOf(keepAliveTime));
                poolBaseInfo.setRejectedName("-");
                poolBaseInfo.setQueueType("-");
            }
            catch (Exception ex) {
                log.error("The undertow container failed to get thread pool parameters.", (Throwable)ex);
            }
        }
        return poolBaseInfo;
    }

    @Override
    protected PoolRunStateInfo supplement(PoolRunStateInfo poolRunStateInfo) {
        RuntimeInfo runtimeInfo = new RuntimeInfo();
        String memoryProportion = StrUtil.builder((CharSequence[])new CharSequence[]{"\u5df2\u5206\u914d: ", ByteConvertUtil.getPrintSize(runtimeInfo.getTotalMemory()), " / \u6700\u5927\u53ef\u7528: ", ByteConvertUtil.getPrintSize(runtimeInfo.getMaxMemory())}).toString();
        poolRunStateInfo.setCurrentLoad(poolRunStateInfo.getCurrentLoad() + "%");
        poolRunStateInfo.setPeakLoad(poolRunStateInfo.getPeakLoad() + "%");
        poolRunStateInfo.setMemoryProportion(memoryProportion);
        poolRunStateInfo.setFreeMemory(ByteConvertUtil.getPrintSize(runtimeInfo.getFreeMemory()));
        return poolRunStateInfo;
    }
}

