/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.handler.web;

import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.starter.handler.web.AbstractWebThreadPoolService;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;

public class TomcatWebThreadPoolHandler
extends AbstractWebThreadPoolService {
    private static final Logger log = LoggerFactory.getLogger(TomcatWebThreadPoolHandler.class);
    private final AtomicBoolean cacheFlag = new AtomicBoolean(Boolean.FALSE);
    private static String EXCEPTION_MESSAGE;

    @Override
    protected Executor getWebThreadPoolByServer(WebServer webServer) {
        if (this.cacheFlag.get()) {
            log.warn("Exception getting Tomcat thread pool. Exception message :: {}", (Object)EXCEPTION_MESSAGE);
            return null;
        }
        Executor tomcatExecutor = null;
        try {
            tomcatExecutor = ((TomcatWebServer)webServer).getTomcat().getConnector().getProtocolHandler().getExecutor();
        }
        catch (Exception ex) {
            this.cacheFlag.set(Boolean.TRUE);
            EXCEPTION_MESSAGE = ex.getMessage();
            log.error("Failed to get Tomcat thread pool. Message :: {}", (Object)EXCEPTION_MESSAGE);
        }
        return tomcatExecutor;
    }

    @Override
    public void updateWebThreadPool(PoolParameterInfo poolParameterInfo) {
        try {
            ThreadPoolExecutor tomcatExecutor = (ThreadPoolExecutor)this.executor;
            int originalCoreSize = tomcatExecutor.getCorePoolSize();
            int originalMaximumPoolSize = tomcatExecutor.getMaximumPoolSize();
            long originalKeepAliveTime = tomcatExecutor.getKeepAliveTime(TimeUnit.SECONDS);
            tomcatExecutor.setCorePoolSize(poolParameterInfo.getCoreSize().intValue());
            tomcatExecutor.setMaximumPoolSize(poolParameterInfo.getMaxSize().intValue());
            tomcatExecutor.setKeepAliveTime((long)poolParameterInfo.getKeepAliveTime().intValue(), TimeUnit.SECONDS);
            log.info("\ud83d\udd25 Changed web thread pool. coreSize :: [{}], maxSize :: [{}], keepAliveTime :: [{}]", new Object[]{String.format("%s => %s", originalCoreSize, poolParameterInfo.getCoreSize()), String.format("%s => %s", originalMaximumPoolSize, poolParameterInfo.getMaxSize()), String.format("%s => %s", originalKeepAliveTime, poolParameterInfo.getKeepAliveTime())});
        }
        catch (Exception ex) {
            log.error("Failed to modify the Tomcat thread pool parameter.", (Throwable)ex);
        }
    }
}

